% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propr-phit.R
\name{phit}
\alias{phit}
\title{Calculate proportionality metric phi.}
\usage{
phit(counts, symmetrize = TRUE, iter = 0, iterSize = ncol(counts),
  iterHow = 1, onlyDistr = FALSE)
}
\arguments{
\item{counts}{A data.frame or matrix. A "count matrix" with subjects as rows and features as columns.}

\item{symmetrize}{A logical. If \code{TRUE}, forces symmetry by duplicating the "lower left triangle".}

\item{iter}{A numeric scalar. Fits \code{iter*iterSize*(iterSize-1)/2} values to an empiric distribution. Skip with \code{iter = 0}.}

\item{iterSize}{A numeric scalar. Fits \code{iter*iterSize*(iterSize-1)/2} values to an empiric distribution.}

\item{iterHow}{A numeric scalar. Select \code{1} to randomize feature vectors or \code{2} to randomize subject vectors.}

\item{onlyDistr}{A logical. Provided for backend use. Evokes function to return only \code{ecdf} fit.}
}
\value{
Returns a \code{propr} object.
}
\description{
\code{phit} returns a \code{propr} object containing measures of proportionality.
}
\details{
Let d represent any number of features measured across multiple biological replicates n
	subjected to a binary or continuous event E. For example, E could represent case-control
	status, treatment status, treatment dose, or time. This function converts a
	"count matrix" with n rows and d columns into a proportionality matrix of d rows and d
	columns containing phi measurements for each feature pair. One can think of the resultant
	matrix as equivalent to a distance matrix, except that it has no symmetry by default.
}
\examples{
randomNum <- sample(1:1000, size = 25 * 10, replace = TRUE)
counts <- matrix(randomNum, nrow = 25, ncol = 10)
prop <- phit(counts, symmetrize = TRUE, iter = 0)
}
\seealso{
\code{\link{propr}}, \code{\link{propr-class}}, \code{\link{perb}}
}

