% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{propr-class}
\alias{propr-class}
\title{An S4 class to hold results from proportionality analysis.}
\description{
An S4 class to hold results from proportionality analysis.
}
\section{Slots}{

\describe{
\item{\code{counts}}{A matrix. Stores the original "count matrix" input.}

\item{\code{logratio}}{A matrix. Stores the log-ratio transformed "count matrix".}

\item{\code{matrix}}{A matrix. Stores the proportionality matrix calculated by
\code{phiRcpp} or \code{rhoRcpp}.}

\item{\code{pairs}}{A vector. Indexes the proportionality metrics of interest.}
}}
\examples{
set.seed(12345)
N <- 100
X <- data.frame(a=(1:N), b=(1:N) * rnorm(N, 10, 0.1),
                c=(N:1), d=(N:1) * rnorm(N, 10, 1.0))
rho <- perb(X, ivar = 0)
rho[">", .99]
subset(rho, 1:2)
}
\seealso{
\code{\link{propr}}, \code{\link{phit}}, \code{\link{perb}}
}

