% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/desc03TC.R
\name{extractTC}
\alias{extractTC}
\title{Tripeptide Composition Descriptor}
\usage{
extractTC(x)
}
\arguments{
\item{x}{A character vector, as the input protein sequence.}
}
\value{
A length 8000 named vector
}
\description{
Tripeptide Composition Descriptor
}
\details{
This function calculates the Tripeptide Composition descriptor (Dim: 8000).
}
\examples{
x = readFASTA(system.file('protseq/P00750.fasta', package = 'protr'))[[1]]
extractTC(x)
}
\author{
Nan Xiao <\url{http://r2s.name}>
}
\references{
M. Bhasin, G. P. S. Raghava.
Classification of Nuclear Receptors Based on
Amino Acid Composition and Dipeptide Composition.
\emph{Journal of Biological Chemistry}, 2004, 279, 23262.
}
\seealso{
See \code{\link{extractAAC}} and \code{\link{extractDC}}
         for Amino Acid Composition and Dipeptide Composition descriptors.
}
\keyword{Composition}
\keyword{Tripeptide}
\keyword{extract}

