% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc-10-CTriad.R
\name{extractCTriad}
\alias{extractCTriad}
\title{Conjoint Triad Descriptor}
\usage{
extractCTriad(x)
}
\arguments{
\item{x}{A character vector, as the input protein sequence.}
}
\value{
A length 343 named vector
}
\description{
This function calculates the Conjoint Triad descriptor (dim: 343).
}
\note{
For this descriptor type, users need to intelligently evaluate
the underlying details of the descriptors provided, instead of using
this function with their data blindly. It would be wise to use some
negative and positive control comparisons where relevant to help guide
interpretation of the results.
}
\examples{
x = readFASTA(system.file("protseq/P00750.fasta", package = "protr"))[[1]]
extractCTriad(x)
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\references{
J.W. Shen, J. Zhang, X.M. Luo, W.L. Zhu,
K.Q. Yu, K.X. Chen, Y.X. Li, H.L. Jiang.
Predicting Protein-protein Interactions Based Only on Sequences Information.
\emph{Proceedings of the National Academy of Sciences}. 007, 104, 4337--4341.
}
\keyword{Conjoint}
\keyword{Triad}
\keyword{extract}

