% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc-10-CTriadClass.R
\name{extractCTriadClass}
\alias{extractCTriadClass}
\title{Conjoint Triad Descriptor (with customized amino acid
classification support)}
\usage{
extractCTriadClass(x, aaclass)
}
\arguments{
\item{x}{A character vector, as the input protein sequence.}

\item{aaclass}{A list containing the customized amino acid
classification. See example below.}
}
\value{
A length \code{k^3} named vector, where \code{k} is the number
of customized classes of the amino acids.
}
\description{
This function calculates the Conjoint Triad descriptor, with customized
amino acid classification support.
}
\note{
For this descriptor type, users need to intelligently evaluate
the underlying details of the descriptors provided, instead of using
this function with their data blindly. It would be wise to use some
negative and positive control comparisons where relevant to help guide
interpretation of the results.
}
\examples{
x = readFASTA(system.file("protseq/P00750.fasta", package = "protr"))[[1]]

# use customized amino acid classification (normalized van der Waals volume)
newclass = list(
  c("G", "A", "S", "T", "P", "D", "C"),
  c("N", "V", "E", "Q", "I", "L"),
  c("M", "H", "K", "F", "R", "Y", "W"))

extractCTriadClass(x, aaclass = newclass)
}
\references{
J.W. Shen, J. Zhang, X.M. Luo, W.L. Zhu,
K.Q. Yu, K.X. Chen, Y.X. Li, H.L. Jiang.
Predicting Protein-protein Interactions Based Only on Sequences Information.
\emph{Proceedings of the National Academy of Sciences}. 007, 104, 4337--4341.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\keyword{Conjoint}
\keyword{Triad}
\keyword{extract}
