/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.stream;

import com.qarks.util.Log;
import com.qarks.util.Synchronizer;
import com.qarks.util.stream.CorePipedInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CorePipedOutputStream
extends OutputStream {
    private byte[] mBuffer = null;
    private int mSize = 0;
    private int mWriteOffset = 0;
    private int mReadOffset = 0;
    private int mAvailable = 0;
    private boolean mClosed = false;
    private Object mSync = new Object();
    private static int PIPE_SIZE = 1024;
    boolean mConnected = false;
    private Synchronizer mNotificationWrite = new Synchronizer();
    private Synchronizer mNotificationRead = new Synchronizer();
    private Synchronizer mNotificationEnd = new Synchronizer();
    CorePipedInputStream mPis = null;

    public CorePipedOutputStream(int n) {
        this.mSize = n;
        this.mBuffer = new byte[n];
    }

    public CorePipedOutputStream() {
        this(PIPE_SIZE);
    }

    public int getBufferSize() {
        return this.mBuffer.length;
    }

    public CorePipedOutputStream(CorePipedInputStream corePipedInputStream, int n) throws IOException {
        this(n);
        this.connect(corePipedInputStream);
    }

    public CorePipedOutputStream(CorePipedInputStream corePipedInputStream) throws IOException {
        this(corePipedInputStream, PIPE_SIZE);
    }

    public boolean canBeReused() {
        return this.mConnected && this.mPis.isClosed() && this.mClosed;
    }

    public void reset() {
        if (!this.canBeReused()) {
            Log.logWarning(this, "Reset OutputPipe with inputStream not closed");
        }
        this.mReadOffset = 0;
        this.mWriteOffset = 0;
        this.mAvailable = 0;
        this.mClosed = false;
        this.mPis.open();
        this.mNotificationWrite.reset();
        this.mNotificationRead.reset();
        this.mNotificationEnd.reset();
    }

    public void connect(CorePipedInputStream corePipedInputStream) throws IOException {
        this.mPis = corePipedInputStream;
        this.mPis.mPos = this;
        this.mPis.mConnected = true;
        this.mConnected = true;
    }

    @Override
    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)(n & 0xFF)});
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        block14: {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            try {
                if (!this.mConnected) {
                    throw new IOException("OutputPipe not connected");
                }
                if (this.mClosed) {
                    throw new IOException("OutputPipe closed");
                }
                while (n2 > 0) {
                    Object object = this.mSync;
                    synchronized (object) {
                        if (this.mAvailable < this.mSize && (n6 = Math.min(n4 = Math.min(this.mSize - this.mWriteOffset, n2), this.mSize - this.mAvailable)) > 0) {
                            System.arraycopy(byArray, n, this.mBuffer, this.mWriteOffset, n6);
                            this.mAvailable += n6;
                            this.mWriteOffset += n6;
                            n += n6;
                            if (this.mWriteOffset == this.mSize) {
                                this.mWriteOffset = 0;
                            }
                            n3 += n6;
                            if ((n2 -= n6) > 0 && this.mSize - this.mAvailable > 0) {
                                if (this.mWriteOffset != 0) {
                                    throw new IOException("offset should not be != 0");
                                }
                                n5 = Math.min(this.mSize - this.mAvailable, n2);
                                System.arraycopy(byArray, n, this.mBuffer, 0, n5);
                                this.mAvailable += n5;
                                this.mWriteOffset = n5;
                                n += n5;
                                n2 -= n5;
                                n3 += n5;
                            }
                        }
                        if (this.mAvailable > 0) {
                            this.mNotificationRead.notifyEvent();
                        }
                    }
                    if (n2 <= 0) continue;
                    if (this.mClosed) {
                        throw new IOException("OutputPipe closed before waiting for available space");
                    }
                    this.mNotificationWrite.waitEvents();
                }
            }
            catch (Throwable throwable) {
                Log.logError(this, "Exception while writing.", throwable);
                if (!(throwable instanceof IOException)) break block14;
                throw (IOException)throwable;
            }
        }
    }

    @Override
    public void flush() throws IOException {
    }

    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public void close() throws IOException {
        this.mClosed = true;
        this.mNotificationWrite.notifyEvent();
        if (this.mAvailable == 0) {
            this.mNotificationRead.notifyEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int receive(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        block11: {
            n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            n2 = Math.min(n2, byArray.length);
            try {
                while (this.available() <= 0) {
                    if (this.isClosed()) {
                        return -1;
                    }
                    this.mNotificationRead.waitEvents();
                }
                Object object = this.mSync;
                synchronized (object) {
                    n4 = Math.min(this.mSize - this.mReadOffset, this.mAvailable);
                    n6 = Math.min(n4, n2);
                    System.arraycopy(this.mBuffer, this.mReadOffset, byArray, n, n6);
                    this.mAvailable -= n6;
                    this.mReadOffset += n6;
                    n += n6;
                    n2 -= n6;
                    n3 += n6;
                    if (this.mReadOffset == this.mSize) {
                        this.mReadOffset = 0;
                    }
                    if (n2 > 0 && this.mAvailable > 0) {
                        n5 = Math.min(this.mAvailable, n2);
                        System.arraycopy(this.mBuffer, 0, byArray, n, n5);
                        this.mAvailable -= n5;
                        this.mReadOffset = n5;
                        n += n5;
                        n2 -= n5;
                        n3 += n5;
                    }
                }
                if (n3 > 0) {
                    this.mNotificationWrite.notifyEvent();
                }
            }
            catch (Throwable throwable) {
                Log.logError(this, "Exception while receiving.", throwable);
                if (!(throwable instanceof IOException)) break block11;
                throw (IOException)throwable;
            }
        }
        if (n3 == 0) {
            Log.logWarning(this, "receive should never return 0");
        }
        return n3;
    }

    int available() {
        int n = this.mAvailable;
        if (n == 0 && this.mClosed) {
            n = -1;
        }
        return n;
    }
}

