/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.files.diff.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;

public class MergeButton
extends JButton {
    private Color color;
    private boolean active = false;
    private boolean border = true;
    private boolean rolledOver = false;

    public MergeButton(String string) {
        this(string, Color.lightGray);
        this.border = false;
    }

    public MergeButton(String string, Color color) {
        super(string);
        this.color = color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.border = true;
    }

    public void setActive(boolean bl) {
        this.active = bl;
        if (bl) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    MergeButton.this.rolledOver = true;
                    MergeButton.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    MergeButton.this.rolledOver = false;
                    MergeButton.this.repaint();
                }
            });
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.active) {
            if (this.border) {
                if (this.rolledOver) {
                    graphics.setColor(this.color.darker());
                    graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                } else {
                    graphics.setColor(this.color.brighter());
                    graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                }
                graphics.setColor(this.color);
                graphics.fillRect(1, 1, dimension.width - 2, dimension.height - 2);
            } else {
                graphics.setColor(this.color);
                graphics.fillRect(2, 0, dimension.width - 4, dimension.height);
            }
        } else {
            graphics.setColor(Color.lightGray);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
    }
}

