% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolbox.R
\name{CLR}
\alias{CLR}
\title{Centred logratio transformation}
\usage{
CLR(x)
}
\arguments{
\item{x}{an object of class \code{compositional}}
}
\value{
a matrix of CLR coordinates
}
\description{
Calculates Aitchison's centered logratio transformation for a
dataset of class \code{compositional}
}
\examples{
# The following code shows that applying provenance's PCA function
# to compositional data is equivalent to applying R's built-in
# princomp function to the CLR transformed data.
data(Namib)
plot(PCA(Namib$Major))
dev.new()
clrdat <- CLR(Namib$Major)$x
biplot(princomp(clrdat))
}
