# PRQL query

    Code
      cat(prql_compile("from a | select [b]"))
    Output
      SELECT
        b
      FROM
        a
      
      -- Generated by PRQL compiler version:0.5.1 (https://prql-lang.org)

---

    Code
      cat(prql_compile("from a | select [b]", NA, FALSE, FALSE))
    Output
      SELECT b FROM a

---

    Code
      cat(unwrap(compile(
        "from star_wars\n    select [star_wars.*]\n    select ![jar_jar_binks, midichlorians]",
        "sql.duckdb", TRUE, TRUE)))
    Output
      SELECT
        * EXCLUDE (jar_jar_binks, midichlorians)
      FROM
        star_wars
      
      -- Generated by PRQL compiler version:0.5.1 target:sql.duckdb (https://prql-lang.org)

# Targets target=sql.ansi

    Code
      cat(prql_compile(query, target, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200
        AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Targets target=sql.bigquery

    Code
      cat(prql_compile(query, target, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200
        AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Targets target=sql.clickhouse

    Code
      cat(prql_compile(query, target, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200
        AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Targets target=sql.duckdb

    Code
      cat(prql_compile(query, target, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200
        AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Targets target=sql.generic

    Code
      cat(prql_compile(query, target, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200
        AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Targets target=sql.hive

    Code
      cat(prql_compile(query, target, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200
        AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Targets target=sql.mssql

    Code
      cat(prql_compile(query, target, TRUE, FALSE))
    Output
      SELECT
        TOP (2) origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200
        AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay

# Targets target=sql.mysql

    Code
      cat(prql_compile(query, target, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200
        AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Targets target=sql.postgres

    Code
      cat(prql_compile(query, target, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200
        AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Targets target=sql.sqlite

    Code
      cat(prql_compile(query, target, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200
        AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Targets target=sql.snowflake

    Code
      cat(prql_compile(query, target, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200
        AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

