% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/make-call.R
\name{make_call}
\alias{do_call}
\alias{make_call}
\title{Make and evaluate calls.}
\usage{
make_call(f, ..., .args = list())

do_call(f, ..., .args = list(), .env = parent.frame())
}
\arguments{
\item{f}{Function to call. For \code{make_call}, either a string, a symbol
or a quoted call. For \code{do_call}, a bare function name or call.}

\item{...,.args}{Arguments to the call either in or out of a list}

\item{.env}{Environment in which to evaluate call. Defaults to parent frame.}
}
\description{
Make and evaluate calls.
}
\examples{
# f can either be a string, a symbol or a call
make_call("f", a = 1)
make_call(quote(f), a = 1)
make_call(quote(f()), a = 1)

#' Can supply arguments individual or in a list
make_call(quote(f), a = 1, b = 2)
make_call(quote(f), list(a = 1, b = 2))
}

