% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/low-level.R
\name{ps_children}
\alias{ps_children}
\title{List of child processes (process objects) of the process. Note that
this typically requires enumerating all processes on the system, so
it is a costly operation.}
\usage{
ps_children(p, recursive = FALSE)
}
\arguments{
\item{p}{Process handle.}

\item{recursive}{Whether to include the children of the children, etc.}
}
\value{
List of \code{ps_handle} objects.
}
\description{
List of child processes (process objects) of the process. Note that
this typically requires enumerating all processes on the system, so
it is a costly operation.
}
\examples{
\dontshow{if (ps::ps_is_supported()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
p <- ps_parent(ps_handle())
ps_children(p)
\dontshow{\}) # examplesIf}
}
\seealso{
Other process handle functions: 
\code{\link{ps_cmdline}()},
\code{\link{ps_connections}()},
\code{\link{ps_cpu_times}()},
\code{\link{ps_create_time}()},
\code{\link{ps_cwd}()},
\code{\link{ps_environ}()},
\code{\link{ps_exe}()},
\code{\link{ps_handle}()},
\code{\link{ps_interrupt}()},
\code{\link{ps_is_running}()},
\code{\link{ps_kill}()},
\code{\link{ps_memory_info}()},
\code{\link{ps_name}()},
\code{\link{ps_num_fds}()},
\code{\link{ps_num_threads}()},
\code{\link{ps_open_files}()},
\code{\link{ps_pid}()},
\code{\link{ps_ppid}()},
\code{\link{ps_resume}()},
\code{\link{ps_send_signal}()},
\code{\link{ps_status}()},
\code{\link{ps_suspend}()},
\code{\link{ps_terminal}()},
\code{\link{ps_terminate}()},
\code{\link{ps_uids}()},
\code{\link{ps_username}()}
}
\concept{process handle functions}
