% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disk.R
\name{ps_fs_info}
\alias{ps_fs_info}
\title{File system information for files}
\usage{
ps_fs_info(paths = "/")
}
\arguments{
\item{paths}{A path or a vector of paths. \code{ps_fs_info()} returns
information about the file systems of all paths. \code{path} may contain
direcories as well.}
}
\value{
Data frame with file system information for each
path in \code{paths}, one row per path. Common columns for all
operating systems:
\itemize{
\item \code{path}: The input paths, i.e. the \code{paths} argument.
\item \code{mountpoint}: Directory where the file system is mounted.
On Linux there is a small chance that it was not possible to
look this up, and it is \code{NA_character_}. This is the drive letter
or the mount directory on Windows, with a trailing \verb{\\}.
\item \code{name}: Device name.
On Linux there is a small chance that it was not possible to
look this up, and it is \code{NA_character_}. On Windows this is the
volume GUID path of the form \verb{\\\\?\\Volume\{GUID\}\\}.
\item \code{type}: File system type (character).
On Linux there is a tiny chance that it was not possible to
look this up, and it is \code{NA_character_}.
\item \code{block_size}: File system block size. This is the sector size on
Windows, in bytes.
\item \code{transfer_block_size}: Pptimal transfer block size. On Linux it is
currently always the same as \code{block_size}. This is the cluster size
on Windows, in bytes.
\item \code{total_data_blocks}: Total data blocks in file system. On Windows
this is the number of sectors.
\item \code{free_blocks}: Free blocks in file system. On Windows this is the
number of free sectors.
\item \code{free_blocks_non_superuser}: Free blocks for a non-superuser, which
might be different on Unix. On Windows this is the number of free
sectors for the calling user.
\item \code{id}: File system id. This is a raw vector. On Linux it is
often all zeros. It is always \code{NULL} on Windows.
\item \code{owner}: User that mounted the file system. On Linux and Windows
this is currently always \code{NA_real_}.
\item \code{type_code}: Type of file system, a numeric code. On Windows this
this is \code{NA_real_}.
\item \code{subtype_code}: File system subtype (flavor). On Linux and Windows
this is always \code{NA_real_}.
}

The rest of the columns are flags, and they are operating system
dependent.

macOS:
\itemize{
\item \code{RDONLY}: A read-only filesystem.
\item \code{SYNCHRONOUS}: File system is written to synchronously.
\item \code{NOEXEC}: Can't exec from filesystem.
\item \code{NOSUID}: Setuid bits are not honored on this filesystem.
\item \code{NODEV}: Don't interpret special files.
\item \code{UNION}: Union with underlying filesysten.
\item \code{ASYNC}: File system written to asynchronously.
\item \code{EXPORTED}: File system is exported.
\item \code{LOCAL}: File system is stored locally.
\item \code{QUOTA}: Quotas are enabled on this file system.
\item \code{ROOTFS}: This file system is the root of the file system.
\item \code{DOVOLFS}: File system supports volfs.
\item \code{DONTBROWSE}: File system is not appropriate path to user data.
\item \code{UNKNOWNPERMISSIONS}:  VFS will ignore ownership information on
filesystem filesystemtem objects.
\item \code{AUTOMOUNTED}: File system was mounted by automounter.
\item \code{JOURNALED}: File system is journaled.
\item \code{DEFWRITE}: File system should defer writes.
\item \code{MULTILABEL}: MAC support for individual labels.
\item \code{CPROTECT}: File system supports per-file encrypted data protection.
}

Linux:
\itemize{
\item \code{MANDLOCK}: Mandatory locking is permitted on the filesystem
(see \code{fcntl(2)}).
\item \code{NOATIME}: Do not update access times; see \code{mount(2)}.
\item \code{NODEV}: Disallow access to device special files on this filesystem.
\item \code{NODIRATIME}: Do not update directory access times; see mount(2).
\item \code{NOEXEC}: Execution of programs is disallowed on this filesystem.
\item \code{NOSUID}: The set-user-ID and set-group-ID bits are ignored by
\code{exec(3)} for executable files on this filesystem
\item \code{RDONLY}: This filesystem is mounted read-only.
\item \code{RELATIME}: Update atime relative to mtime/ctime; see \code{mount(2)}.
\item \code{SYNCHRONOUS}: Writes are synched to the filesystem immediately
(see the description of \code{O_SYNC} in `open(2)``).
\item \code{NOSYMFOLLOW}: Symbolic links are not followed when resolving paths;
see `mount(2)``.
}

Windows:
\itemize{
\item \code{CASE_SENSITIVE_SEARCH}: Supports case-sensitive file names.
\item \code{CASE_PRESERVED_NAMES}: Supports preserved case of file names when
it places a name on disk.
\item \code{UNICODE_ON_DISK}: Supports Unicode in file names as they appear on
disk.
\item \code{PERSISTENT_ACLS}: Preserves and enforces access control lists
(ACL). For example, the NTFS file system preserves and enforces
ACLs, and the FAT file system does not.
\item \code{FILE_COMPRESSION}: Supports file-based compression.
\item \code{VOLUME_QUOTAS}: Supports disk quotas.
\item \code{SUPPORTS_SPARSE_FILES}: Supports sparse files.
\item \code{SUPPORTS_REPARSE_POINTS}: Supports reparse points.
\item \code{SUPPORTS_REMOTE_STORAGE}: Supports remote storage.
\item \code{RETURNS_CLEANUP_RESULT_INFO}: On a successful cleanup operation,
the file system returns information that describes additional
actions taken during cleanup, such as deleting the file. File
system filters can examine this information in their post-cleanup
callback.
\item \code{SUPPORTS_POSIX_UNLINK_RENAME}: Supports POSIX-style delete and
rename operations.
\item \code{VOLUME_IS_COMPRESSED}: It is a compressed volume, for example, a
DoubleSpace volume.
\item \code{SUPPORTS_OBJECT_IDS}: Supports object identifiers.
\item \code{SUPPORTS_ENCRYPTION}: Supports the Encrypted File System (EFS).
\item \code{NAMED_STREAMS}: Supports named streams.
\item \code{READ_ONLY_VOLUME}: It is read-only.
\item \code{SEQUENTIAL_WRITE_ONCE}: Supports a single sequential write.
\item \code{SUPPORTS_TRANSACTIONS}: Supports transactions.
\item \code{SUPPORTS_HARD_LINKS}: The volume supports hard links.
\item \code{SUPPORTS_EXTENDED_ATTRIBUTES}: Supports extended attributes.
\item \code{SUPPORTS_OPEN_BY_FILE_ID}: Supports open by FileID.
\item \code{SUPPORTS_USN_JOURNAL}: Supports update sequence number (USN)
journals.
\item \code{SUPPORTS_INTEGRITY_STREAMS}: Supports integrity streams.
\item \code{SUPPORTS_BLOCK_REFCOUNTING}: The volume supports sharing logical
clusters between files on the same volume.
\item \code{SUPPORTS_SPARSE_VDL}: The file system tracks whether each cluster
of a file contains valid data (either from explicit file writes or
automatic zeros) or invalid data (has not yet been written to or
zeroed).
\item \code{DAX_VOLUME}: The volume is a direct access (DAX) volume.
\item \code{SUPPORTS_GHOSTING}: Supports ghosting.
}
}
\description{
File system information for files
}
\examples{
\dontshow{if (ps::ps_is_supported() && ! ps:::is_cran_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ps_fs_info(c("/", "~", "."))
\dontshow{\}) # examplesIf}
}
