% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psborrow.bin.R
\name{psborrow.bin}
\alias{psborrow.bin}
\title{Simulation study of hybrid control design with Bayesian dynamic borrowing
incorporating propensity score matched external control: binary outcome}
\usage{
psborrow.bin(
  n.CT, n.CC, n.ECp, n.EC,
  out.prob.CT, out.prob.CC, driftOR,
  cov.C, cov.cor.C, cov.EC, cov.cor.EC, cov.effect,
  psmatch.cov,
  method.psest="glm", method.pslink="logit",
  method.whomatch, method.matching, method.psorder, n.boot=100,
  analysis.cov, method.borrow,
  chains=2, iter=4000, warmup=floor(iter/2), thin=1,
  alternative="greater", sig.level=0.025, nsim)
}
\arguments{
\item{n.CT}{Number of patients in treatment group in the current trial.}

\item{n.CC}{Number of patients in concurrent control group in the current
trial.}

\item{n.ECp}{Number of patients in external control pool.}

\item{n.EC}{Number of patients in external control.}

\item{out.prob.CT}{True rate of outcome in treatment group in the current
trial.}

\item{out.prob.CC}{True rate of outcome in concurrent control group in the
current trial.}

\item{driftOR}{Odds ratio between concurrent and external control
for which the bias should be plotted.}

\item{cov.C}{List of covariate distributions for treatment and concurrent
control group in the current trial. Continuous and binary covariate are
applicable. The continuous covariate is assumed to follow a normal
distribution; for example, specified as
\code{list(dist="norm", mean=0, sd=1, lab="cov1")}. The binary covariate is
assumed to follow a binomial distribution; for example, specified as
\code{list(dist="binom", prob=0.4, lab="cov2")}. \code{lab} is the column
name of the covariate in the data frame generated.}

\item{cov.cor.C}{Matrix of correlation coefficients for each pair of
covariate for treatment and concurrent control group in the current trial,
specified as Gaussian copula parameter.}

\item{cov.EC}{List of covariate distributions for external control. The
continuous covariate is assumed to follow a normal distribution; for example,
specified as \code{list(dist="norm", mean=0, sd=1, lab="cov1")}. The binary
covariate is assumed to follow a binomial distribution; for example,
specified as \code{list(dist="binom", prob=0.4, lab="cov2")}. \code{lab} is
the column name of the covariate in the data frame generated, which must be
consistent with those used for \code{cov.C}.}

\item{cov.cor.EC}{Matrix of correlation coefficients for each pair of
covariate for external control, specified as Gaussian copula parameter.}

\item{cov.effect}{Vector of covariate effects on the outcome, specified as
odds ratio per one unit increase in continuous covariates or as odds ratio
between categories for binary covariates.}

\item{psmatch.cov}{Vector of names of covariates which are used for the
propensity score matching. The names of covariates must be included in
\code{lab} values specified in \code{cov.C}.}

\item{method.psest}{Method of estimating the propensity score. Allowable
options include, for example, \code{"glm"} for generalized linear model
(e.g., logistic regression); \code{"gam"} for generalized additive model;
\code{"gbm"} for generalized boosted model; \code{"lasso"} for lasso
regression; \code{"rpart"} for classification tree. The default value is
\code{method.psest="glm"}.}

\item{method.pslink}{Link function used in estimating the propensity score.
Allowable options depend on the specific \code{method.psest} value specified.
The default value is \code{method.pslink="logit"}, which, along with
\code{method.psest="glm"}, identifies the default method as logistic
regression.}

\item{method.whomatch}{Options of who to match. Allowable options include
\code{conc.contl} for matching concurrent control to external control pool;
\code{conc.treat} for matching treatment to external control pool;
\code{conc.all} for matching treatment plus concurrent control to external
control pool; \code{treat2contl} for matching treatment to concurrent control
plus external control pool.}

\item{method.matching}{Matching method. Allowable options include
\code{"optimal"} for optimal matching; \code{"nearest"} for nearest neighbor
matching without replacement; \code{"med.optimal"} for equally splitting
patients in the current trial and taking the median of each subset, followed
by 1:1 optimal matching; \code{"med.nearest"} for equally splitting
patients in the current trial and taking the median of each subset, followed
by 1:1 nearest neighbor matching without replacement; \code{"km.optimal"} for
k-means clustering of patients in the current trial, followed by 1:1 optimal
matching; \code{"km.nearest"} for k-means clustering of patients in the
current trial, followed by 1:1 nearest neighbor matching without replacement;
\code{"cm.optimal"} for fuzzy c-means clustering of patients in the current
trial, followed by 1:1 optimal matching; \code{"cm.nearest"} for fuzzy
c-means of patients in the current trial, followed by 1:1 nearest neighbor
matching without replacement; \code{"boot.optimal"} for bootstrap sampling
from patients in the current trial, followed by 1:1 optimal matching;
\code{"boot.nearest"} for bootstrap sampling from patient in the current
trial, followed by 1:1 nearest neighbor matching without replacement.}

\item{method.psorder}{Order that the matching takes place when a nearest
neighbor matching is used. Allowable options include \code{"largest"},
where matching takes place in descending order of propensity score;
\code{"smallest"}, where matching takes place in ascending order of
propensity score; \code{"random"}, where matching takes place in a random
order; \code{"data"}, where matching takes place based on the order of units
in the data. The matching order must be specified when using the nearest
neighbor matching.}

\item{n.boot}{Number of bootstrap sampling, which must be specified when
\code{method.matching="boot.optimal"} or
\code{method.matching="boot.nearest"}. The default value is \code{n.boot=100}.}

\item{analysis.cov}{Vector of names of covariates which are used for the
Bayesian analysis with commensurate prior. The names of covariates must be
included in \code{lab} values specified in \code{cov.C}.}

\item{method.borrow}{List of information borrowing method. \code{"noborrow"}
uses the concurrent data only. \code{"fullborrow"} uses the external control
data without discounting. \code{"cauchy"} uses the commensurate prior to
dynamically borrow the external control data, and the commensurability
parameter is assumed to follow a half-Cauchy distribution. \code{"normal"}
uses the commensurate prior to dynamically borrow the external control data,
and the commensurability parameter is assumed to follow a half-normal
distribution. \code{"cauchy"} and \code{"normal"} require to specify the
scale parameter \code{scale} of half-Cauchy and half-normal distribution
respectively.}

\item{chains}{Number of Markov chains in MCMC sampling. The default value is
\code{chains=2}.}

\item{iter}{Number of iterations for each chain (including warmup) in MCMC
sampling. The default value is \code{iter=4000}.}

\item{warmup}{Number of warmup (burnin) iterations per chain in MCMC
sampling. The default value is \code{warmup=floor(iter/2)}.}

\item{thin}{Period for saving samples in MCMC sampling. The default value
is \code{thin=1}.}

\item{alternative}{Alternative hypothesis to be tested ("greater" or "less").
The default value is \code{alternative="greater"}.}

\item{sig.level}{Significance level. The default value is
\code{sig.level=0.025}.}

\item{nsim}{Number of simulated trials.}
}
\value{
The \code{psborrow.bin} returns a list containing the following objects:
\item{reject}{Data frame containing results of Bayesian one-sided hypothesis
testing (whether or not the posterior probability that the log odds ratio
is greater or less than 0 exceeds 1 minus significance level): \code{TRUE}
when significant, otherwise \code{FALSE}.}
\item{theta}{Data frame containing posterior mean, median, and sd of log
odds ratio.}
\item{ov}{Data frame containing (1) overlapping coefficient of propensity
score densities between treatment versus concurrent control plus external
control and between concurrent control versus external control, (2)
overlapping coefficient of continuous covariate densities between treatment
versus concurrent control plus external control and between concurrent
control versus external control, and (3) rate difference of binary covariate
between treatment versus concurrent control plus external control and
between concurrent control versus external control.}
\item{n.CT}{Number of patients in treatment group in the current trial.}
\item{n.CC}{Number of patients in concurrent control group in the current
trial.}
\item{n.ECp}{Number of patients in external control pool.}
\item{n.EC}{Number of patients in external control.}
\item{drift}{Odds ratio between concurrent and external control.}
\item{true.theta}{True log odds ratio}
\item{method.psest}{Method of estimating the propensity score.}
\item{method.pslink}{Link function used in estimating the propensity score.}
\item{method.whomatch}{Option of who to match.}
\item{method.matching}{Propensity score matching method.}
\item{method.psorder}{Order that the matching takes place when a nearest
neighbor matching is used.}
}
\description{
Simulation study is conducted to assess operating characteristics of hybrid
control design with Bayesian dynamic borrowing, where the concurrent control
is augmented by external control. The external controls are selected from
external control pool using a propensity score matching. Commensurate power
prior is used for Bayesian dynamic borrowing. The binary outcome is
applicable.
}
\details{
The simulation study consists of three part: data generation
conducted by \code{trial.simulation.bin} function, propensity score matching
conducted by \code{psmatch} function, and Bayesian analysis with commensurate
prior conducted by \code{commensurate.bin} function. Users can specify
different sets of covariates for the propensity score matching and the
Bayesian analysis.
}
\examples{
n.CT  <- 100
n.CC  <- 50
n.ECp <- 200
n.EC  <- 50

out.prob.CT <- 0.2
out.prob.CC <- 0.2
driftOR     <- 1.0

cov.C <- list(list(dist="norm",mean=0,sd=1,lab="cov1"),
              list(dist="binom",prob=0.4,lab="cov2"))

cov.cor.C <- rbind(c(  1,0.1),
                   c(0.1,  1))

cov.EC <- list(list(dist="norm",mean=0,sd=1,lab="cov1"),
               list(dist="binom",prob=0.4,lab="cov2"))

cov.cor.EC <- rbind(c(  1,0.1),
                    c(0.1,  1))

cov.effect <- c(0.9,0.9)

psmatch.cov <- c("cov1","cov2")

method.whomatch <- "conc.treat"
method.matching <- "optimal"
method.psorder  <- NULL

analysis.cov <- c("cov1")

method.borrow <- list(list(prior="noborrow"),
                      list(prior="normal",scale=0.5))

nsim <- 5

psborrow.bin(
  n.CT=n.CT, n.CC=n.CC, n.ECp=n.ECp, n.EC=n.EC,
  out.prob.CT=out.prob.CT, out.prob.CC=out.prob.CC, driftOR=driftOR,
  cov.C=cov.C, cov.cor.C=cov.cor.C,
  cov.EC=cov.EC, cov.cor.EC=cov.cor.EC, cov.effect=cov.effect,
  psmatch.cov=psmatch.cov, method.whomatch=method.whomatch,
  method.matching=method.matching, method.psorder=method.psorder,
  analysis.cov=analysis.cov, method.borrow=method.borrow,
  chains=1, iter=100, nsim=nsim)
}
