% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_cov.R
\name{match_cov}
\alias{match_cov}
\title{Match}
\usage{
match_cov(dt, match)
}
\arguments{
\item{dt}{a list of \code{matrix}}

\item{match}{A vector of covariates name to match on}
}
\value{
a list of \code{matrix} containing matched cohort information
}
\description{
Match
}
\examples{
# match internal and external trial data using different covariates
smp = set_n(ssC = 140, ssE = 275, ssExt = 100)
covset1 = set_cov(n_cat = 2, n_cont = 0, mu_int = 0, mu_ext = 0, var = 1)
covset2 = set_cov(n_cat = 0, n_cont = 1, mu_int = 62, mu_ext = 65, var = 11)
cObj = c(covset1, covset2)
sample_cov <-
  simu_cov(ssObj = smp, covObj = cObj, HR = 1, driftHR = 1.2, nsim = 2)

# match on covariates 1 and 2
match_cov(dt = sample_cov, match = c("cov1", "cov2"))

# match on all 3 covariates
match_cov(dt = sample_cov, match = c("cov1", "cov2", "cov3"))

}
\keyword{constructor}
