% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{set_enrollment}
\alias{set_enrollment}
\title{Set Enrollment Rates for Internal and External Trials}
\usage{
set_enrollment(object, internal, external = internal)
}
\arguments{
\item{object}{A \code{DataSimObject} from \link{create_data_simulation}}

\item{internal}{\code{DataSimEnrollment} object to define the enrollment times for internal data}

\item{external}{\code{DataSimEnrollment} object to define the enrollment times for external data. Defaults to be the same
as internal.}
}
\value{
A \code{DataSimObject} with updated \code{enrollment_internal} and \code{enrollment_external} slots.
}
\description{
Set Enrollment Rates for Internal and External Trials
}
\examples{
data_sim <- create_data_simulation(
  create_baseline_object(10, 10, 10),
  event_dist = create_event_dist(dist = "exponential", lambdas = 1 / 36)
)
set_enrollment(
  data_sim,
  internal = enrollment_constant(rate = c(10, 5), for_time = c(6, 6)),
  external = enrollment_constant(rate = c(5), for_time = c(20))
)
}
