% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_class.R
\docType{class}
\name{Prior-class}
\alias{Prior-class}
\title{\code{Prior} Class}
\description{
A class for defining priors to be translated to Stan code. Objects of class
\code{Prior} should not be created directly but by one of the specific prior
class constructors.
}
\section{Slots}{

\describe{
\item{\code{stan_code}}{character. Stan implementation of the prior, with
placeholders for parameters surrounded with \verb{\{\{} and \verb{\}\}} to be replaced
with \code{\link[glue:glue]{glue::glue()}}.}

\item{\code{n_param}}{integer. Number of prior parameters.}

\item{\code{constraint}}{character. Support of prior distribution expressed as a
Stan constraint, e.g. \code{"<lower=0, upper=1>"}.}
}}

\seealso{
Prior constructor functions: \code{\link[=prior_bernoulli]{prior_bernoulli()}}, \code{\link[=prior_beta]{prior_beta()}}, \code{\link[=prior_cauchy]{prior_cauchy()}}, \code{\link[=prior_half_cauchy]{prior_half_cauchy()}},
\code{\link[=prior_gamma]{prior_gamma()}}, \code{\link[=prior_normal]{prior_normal()}}, \code{\link[=prior_poisson]{prior_poisson()}}, \code{\link[=uniform_prior]{uniform_prior()}}

Other prior classes: 
\code{\link{PriorBernoulli-class}},
\code{\link{PriorBeta-class}},
\code{\link{PriorCauchy-class}},
\code{\link{PriorExponential-class}},
\code{\link{PriorGamma-class}},
\code{\link{PriorHalfCauchy-class}},
\code{\link{PriorHalfNormal-class}},
\code{\link{PriorNormal-class}},
\code{\link{PriorPoisson-class}},
\code{\link{UniformPrior-class}}
}
\concept{prior classes}
