% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{set_dropout}
\alias{set_dropout}
\title{Set Drop Out Distribution}
\usage{
set_dropout(object, internal_treated, internal_control, external_control)
}
\arguments{
\item{object}{\code{DataSimObject}}

\item{internal_treated}{\code{DataSimEvent} object specifying distribution for internal treated patients.}

\item{internal_control}{\code{DataSimEvent} object specifying distribution for internal control patients.}

\item{external_control}{\code{DataSimEvent} object specifying distribution for external control patients.}
}
\value{
A \code{DataSimObject} with updated \code{internal_treated}, \code{internal_control} and \code{external_control} slots.
}
\description{
Set Drop Out Distribution
}
\details{
\code{DataSimEvent} objects can be specified with \code{\link[=create_event_dist]{create_event_dist()}}. Currently no \code{beta} parameters can be
used in drop out distributions (unlike for the survival outcome).
}
\examples{
data_sim <- create_data_simulation(
  create_baseline_object(10, 10, 10),
  event_dist = create_event_dist(dist = "exponential", lambdas = 1 / 36)
)
set_dropout(
  data_sim,
  internal_treated = create_event_dist(dist = "exponential", lambdas = 1 / 55),
  internal_control = create_event_dist(dist = "exponential", lambdas = 1 / 50),
  external_control = create_event_dist(dist = "exponential", lambdas = 1 / 40)
)
}
