% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{enrollment_constant}
\alias{enrollment_constant}
\title{Constant Enrollment Rates}
\usage{
enrollment_constant(rate, for_time = rep(1, length(rate)))
}
\arguments{
\item{rate}{Number of patients to enroll per unit time}

\item{for_time}{Number of time periods for each rate. Must be equal length to \code{rate}}
}
\value{
An object of class \link[=DataSimEnrollment-class]{DataSimEnrollment} to be passed to \code{\link[=create_data_simulation]{create_data_simulation()}}
}
\description{
Constant Enrollment Rates
}
\examples{
# 10 patients/month for 6 months, then 5/month for 6 months
enroll_obj <- enrollment_constant(rate = c(10, 5), for_time = c(6, 6))
enroll_obj@fun(n = 80)
}
