% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudohouseholds.R
\name{get_phhs_parallel}
\alias{get_phhs_parallel}
\title{Get Pseudo-Households (PHH) for many regions, with optional parallel processing}
\usage{
get_phhs_parallel(
  regions,
  region_idcol,
  roads,
  region_popcol = NA,
  roads_idcol = NA,
  phh_density = 0.005,
  min_phh_pop = 5,
  min_phhs_per_region = 1,
  min_phh_distance = 25,
  road_buffer_m = 5,
  delta_distance_m = 5,
  skip_unpopulated_regions = TRUE
)
}
\arguments{
\item{regions}{simple feature object, sf tibble where each row is a region}

\item{region_idcol}{character, name of column with unique region id}

\item{roads}{simple feature object, lines or polylines with road network}

\item{region_popcol}{character, name of column with region population}

\item{roads_idcol}{character, name of column containing road unique identifiers}

\item{phh_density}{numeric, parameter given to sf::st_line_sample()}

\item{min_phh_pop}{numeric, minimum population per phh}

\item{min_phhs_per_region}{numeric, minimum phhs per region (it will try its best)}

\item{min_phh_distance}{numeric, minimum distance between phhs in meters}

\item{road_buffer_m}{numeric, buffer in meters for intersections}

\item{delta_distance_m}{numeric, buffer in meters for intersections}

\item{skip_unpopulated_regions}{boolean, should we skip regions with no population?}
}
\value{
a simple feature object with one row per phh in the region
}
\description{
Calculate PHHs for a set of regions using a given road network.
}
\details{
Regions will be processed sequentially by default, but parallel processing
is supported if users call future::plan() before calling this function.

This function is a wrapper around get_phhs_single(), and parameters are
passed on to it.
}
\examples{
 # Create PHHs for the first 2 dissemination blocks in Ottawa, Ontario, without
 # using any parallel processing
 library(sf)
 library(pseudohouseholds)
 phhs <- get_phhs_parallel(region = ottawa_db_shp[1:2,], region_idcol = "DBUID",
 region_popcol = "dbpop2021", roads = ottawa_roads_shp, roads_idcol = "NGD_UID")


 # Create PHHs for the first 20 dissemination blocks in Ottawa, Ontario, using
 # parallel processing (consult documentation for the package future for details
 # about parallel processing).
 \donttest{
 library(future)
 future::plan(future::multisession)
 phhs <- get_phhs_parallel(region = ottawa_db_shp[1:20,], region_idcol = "DBUID",
  region_popcol = "dbpop2021", roads = ottawa_roads_shp, roads_idcol = "NGD_UID")

 # Shut down parallel workers
 future::plan(future::sequential)
}

}
