% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3method.R
\name{hettmansperger_norton_test}
\alias{hettmansperger_norton_test}
\alias{hettmansperger_norton_test.numeric}
\alias{hettmansperger_norton_test.formula}
\title{Hettmansperger-Norton Trend Test for k-Samples}
\usage{
hettmansperger_norton_test(x, ...)

\method{hettmansperger_norton_test}{numeric}(
  x,
  y,
  na.rm = FALSE,
  alternative = c("decreasing", "increasing", "custom"),
  trend = NULL,
  pseudoranks = TRUE,
  ...
)

\method{hettmansperger_norton_test}{formula}(
  formula,
  data,
  na.rm = FALSE,
  alternative = c("decreasing", "increasing", "custom"),
  trend = NULL,
  pseudoranks = TRUE,
  ...
)
}
\arguments{
\item{x}{vector containing the observations}

\item{...}{further arguments are ignored}

\item{y}{vector specifiying the group to which the observations from the x vector belong to}

\item{na.rm}{a logical value indicating if NA values should be removed}

\item{alternative}{either decreasing (trend k, k-1, ..., 1) or increasing (1, 2, ..., k) or custom (then argument trend must be specified)}

\item{trend}{custom numeric vector indicating the trend for the custom alternative, only used if alternative = "custom"}

\item{pseudoranks}{logical value indicating if pseudo-ranks or ranks should be used}

\item{formula}{formula object}

\item{data}{data.frame containing the variables in the formula (observations and group)}
}
\value{
Returns an object.
}
\description{
This function calculates the Hettmansperger-Norton trend test using pseudo-ranks under the null hypothesis H0F: F_1 = ... F_k.
}
\examples{
# create some data, please note that the group factor needs to be ordered
df <- data.frame(data = c(rnorm(40, 3, 1), rnorm(40, 2, 1), rnorm(20, 1, 1)),
  group = c(rep(1,40),rep(2,40),rep(3,20)))
df$group <- factor(df$group, ordered = TRUE)

# you can either test for a decreasing, increasing or custom trend
hettmansperger_norton_test(df$data, df$group, alternative="decreasing")
hettmansperger_norton_test(df$data, df$group, alternative="increasing")
hettmansperger_norton_test(df$data, df$group, alternative="custom", trend = c(1, 3, 2))
}
\references{
Brunner, E., Bathke, A.C., and Konietschke, F. (2018a). Rank- and Pseudo-Rank Procedures for Independent Observations in Factorial Designs - Using R and SAS. Springer Series in Statistics, Springer, Heidelberg. ISBN: 978-3-030-02912-8.

Happ M, Zimmermann G, Brunner E, Bathke AC (2020). Pseudo-Ranks: How to Calculate Them Efficiently in R. Journal of Statistical Software, Code Snippets, *95*(1), 1-22. doi: 10.18637/jss.v095.c01 (URL:https://doi.org/10.18637/jss.v095.c01).

Hettmansperger, T. P., & Norton, R. M. (1987). Tests for patterned alternatives in k-sample problems. Journal of the American Statistical Association, 82(397), 292-299
}
\keyword{export}
