% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive_table.R
\name{descriptive_table}
\alias{descriptive_table}
\title{Descriptive Statistics Table}
\usage{
descriptive_table(
  data,
  cols,
  ...,
  digits = 3,
  descriptive_indicator = c("mean", "sd", "cor"),
  file_path = NULL,
  streamline = FALSE,
  quite = FALSE,
  return_result = FALSE
)
}
\arguments{
\item{data}{\code{data.frame}}

\item{cols}{column(s) need to be included in the table. Support \code{dplyr::select()} syntax.}

\item{...}{additional arguments passed to cor_test. See ?cor_test.}

\item{digits}{number of digit for the descriptive table}

\item{descriptive_indicator}{Default is mean, sd, cor. Options are missing (missing value count), non_missing (non-missing value count), cor (correlation table), n, mean, sd, median, trimmed (trimmed mean), median, mad (median absolute deviation from the median), min, max, range, skew, kurtosis, se (standard error)}

\item{file_path}{file path for export. The function will implicitly pass this argument to the write.csv(file = file_path)}

\item{streamline}{print streamlined output}

\item{quite}{suppress printing output}

\item{return_result}{If it is set to \code{TRUE}, it will return the data frame of the descriptive table}
}
\value{
a \code{data.frame} of the descriptive table
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} \cr
This function generates a table of descriptive statistics (mainly using \code{psych::describe()}) and or a correlation table. User can export this to a csv file (optionally, using the file_path argument). Users can open the csv file with MS Excel then copy and paste the table into MS Word table.
}
\examples{
descriptive_table(iris, cols = where(is.numeric)) # all numeric columns

descriptive_table(iris,
  cols = where(is.numeric),
  # get missing count, non-missing count, and mean & sd & correlation table
  descriptive_indicator = c("missing", "non_missing", "mean", "sd", "cor")
)
}
