% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_model.R
\name{lm_model}
\alias{lm_model}
\title{Linear Regressions / ANOVA / ANCOVA}
\usage{
lm_model(
  data,
  response_variable,
  predictor_variable,
  two_way_interaction_factor = NULL,
  three_way_interaction_factor = NULL,
  quite = FALSE
)
}
\arguments{
\item{data}{\code{data.frame}}

\item{response_variable}{response variable. Support \code{dplyr::select()} syntax.}

\item{predictor_variable}{predictor variable. Support \code{dplyr::select()} syntax. It will automatically remove the response variable from predictor variable, so you can use \code{contains()} or \code{start_with()} safely.}

\item{two_way_interaction_factor}{two-way interaction factors. You need to pass 2+ factor. Support \code{dplyr::select()} syntax.}

\item{three_way_interaction_factor}{three-way interaction factor. You need to pass exactly 3 factors. Specifying three-way interaction factors automatically included all two-way interactions, so please do not specify the two_way_interaction_factor argument. Support \code{dplyr::select()} syntax.}

\item{quite}{suppress printing output}
}
\value{
an object class of \code{lm} representing the linear regression fit
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} \cr
Fit a linear regression using \code{lm()}. Linear regression is used to explore the effect of continuous variables / categorical variables in predicting a normally-distributed continuous variables.
}
\examples{
fit <- lm_model(
  data = iris,
  response_variable = "Sepal.Length",
  predictor_variable = tidyselect::everything(),
  two_way_interaction_factor = c(Sepal.Width, Species)
)
}
