% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{aovJackknifeAdjustment}
\alias{aovJackknifeAdjustment}
\title{adjustJackknifeAdjustment}
\usage{
aovJackknifeAdjustment(aovObj, numVPs)
}
\arguments{
\item{aovObj}{Output from aov or ezANOVA}

\item{numVPs}{The number of participants}
}
\value{
list
}
\description{
Adjust ezANOVA table with corrected F (Fc = F/(n-1)^2) and p values for jackkniffed data (see Ulrich and Miller, 2001.
Using the jackknife-based scoring method for measuring LRP onset effects in factorial designs. Psychophysiology, 38, 816-827.)
}
\examples{
# Example 1:
# create dataframe with 2(Comp: comp vs. incomp) and 2(Side: left vs. right) factors/levels
dat <- createDF(nVP = 20, nTrl = 1,
                design = list("Comp" = c("comp", "incomp"),
                              "Side" = c("left", "right")))

dat <- addDataDF(dat,
                 RT = list("Comp:Side comp:left"    = c(500, 150, 150),
                           "Comp:Side comp:right"   = c(500, 150, 150),
                           "Comp:Side incomp:left"  = c(500, 150, 150),
                           "Comp:Side incomp:right" = c(500, 150, 150)))

aovRT <- aov(RT ~ Comp*Side + Error(VP/(Comp*Side)), dat)
aovRT <- aovJackknifeAdjustment(aovRT, length(unique(dat$VP)))
aovDispTable(aovRT)

# or with ezANOVA
library(ez)
aovRT <- ezANOVA(dat, dv=.(RT), wid = .(VP), within = .(Comp, Side),
                 return_aov = TRUE, detailed = TRUE)
aovRT <- aovJackknifeAdjustment(aovRT, length(unique(dat$VP)))
aovDispTable(aovRT)


}
