% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metareg.R
\name{metareg}
\alias{metareg}
\title{Compute meta-regressions}
\usage{
metareg(ma_obj, max_interaction = 1)
}
\arguments{
\item{ma_obj}{Meta-analysis object.}

\item{max_interaction}{The maximum level at which interactions should be analyzed. Default is 1 (i.e., main effects only).}
}
\value{
ma_obj with meta-regression results added (see ma_obj$follow_up_analyses$meta_regression).
}
\description{
This function is a wrapper for \pkg{metafor}'s \code{rma} function that computes meta-regressions for all bare-bones and individual-correction meta-analyses within an object.
It makes use of both categorical and continuous moderator information stored in the meta-analysis object and allows for interaction effects to be included in the regression model.
Output from this function will be added to the meta-analysis object in a list called \code{follow_up_analyses}.
If using this function with a multi-construct meta-analysis object from \code{\link{ma_r}} or \code{\link{ma_d}}, note that the \code{follow_up_analyses} list is appended to the meta-analysis object belonging
to a specific construct pair within the \code{construct_pairs} list.
}
\examples{
## Meta-analyze the data from Gonzalez-Mule et al. (2014)
## Note: These are corrected data and we have confirmed with the author that
## these results are accurate:
ma_obj <- ma_r_ic(rxyi = rxyi, n = n, hs_override = TRUE, data = data_r_gonzalezmule_2014,
        rxx = rxxi, ryy = ryyi, ux = ux, indirect_rr_x = TRUE,
        correct_rr_x = TRUE, moderators = Complexity)

## Pass the meta-analysis object to the meta-regression function:
ma_obj <- metareg(ma_obj)

## Examine the meta-regression results for the bare-bones and corrected data:
ma_obj$follow_up_analyses$meta_regression$barebones$`Main Effects`
ma_obj$follow_up_analyses$meta_regression$individual_correction$true_score$`Main Effects`
}
\keyword{regression}
