% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_ad.R
\name{create_ad_int}
\alias{create_ad_int}
\title{Generate an artifact distribution object for use in interactive artifact-distribution meta-analysis programs.}
\usage{
create_ad_int(rxxi = NULL, n_rxxi = NULL, wt_rxxi = n_rxxi,
  rxxi_type = rep("alpha", length(rxxi)), rxxa = NULL, n_rxxa = NULL,
  wt_rxxa = n_rxxa, rxxa_type = rep("alpha", length(rxxa)), ux = NULL,
  ni_ux = NULL, wt_ux = ni_ux, ut = NULL, ni_ut = NULL, wt_ut = ni_ut,
  estimate_rxxa = TRUE, estimate_rxxi = TRUE, estimate_ux = TRUE,
  estimate_ut = TRUE, ...)
}
\arguments{
\item{rxxi}{Vector of incumbent reliability estimates.}

\item{n_rxxi}{Vector of sample sizes associated with the elements of \code{rxxi}.}

\item{wt_rxxi}{Vector of weights associated with the elements of \code{rxxi}.}

\item{rxxi_type, rxxa_type}{String vector identifying the types of reliability estimates supplied (e.g., "alpha", "retest", "interrater_r", "splithalf"). See the documentation for \code{\link{ma_r}} for a full list of acceptable reliability types.}

\item{rxxa}{Vector of applicant reliability estimates.}

\item{n_rxxa}{Vector of sample sizes associated with the elements of \code{rxxa}.}

\item{wt_rxxa}{Vector of weights associated with the elements of \code{rxxa}.}

\item{ux}{Vector of observed-score u ratios.}

\item{ni_ux}{Vector of incumbent sample sizes associated with the elements of \code{ux}.}

\item{wt_ux}{Vector of weights associated with the elements of \code{ux}.}

\item{ut}{Vector of true-score u ratios.}

\item{ni_ut}{Vector of incumbent sample sizes associated with the elements of \code{ut}.}

\item{wt_ut}{Vector of weights associated with the elements of \code{ut}.}

\item{estimate_rxxa}{Logical argument to estimate rxxa values from other artifacts (\code{TRUE}) or to only used supplied rxxa values (\code{FALSE}). \code{TRUE} by  default.}

\item{estimate_rxxi}{Logical argument to estimate rxxi values from other artifacts (\code{TRUE}) or to only used supplied rxxi values (\code{FALSE}). \code{TRUE} by  default.}

\item{estimate_ux}{Logical argument to estimate ux values from other artifacts (\code{TRUE}) or to only used supplied ux values (\code{FALSE}). \code{TRUE} by  default.}

\item{estimate_ut}{Logical argument to estimate ut values from other artifacts (\code{TRUE}) or to only used supplied ut values (\code{FALSE}). \code{TRUE} by  default.}

\item{...}{Further arguments.}
}
\value{
Artifact distribution object (list of artifact-distribution tables) for use in interactive artifact-distribution meta-analyses.
}
\description{
This function generates \code{ad_obj} class objects containing interactive artifact distributions. Use this to create objects that can be supplied to the \code{ma_r_ad} and
\code{ma_d_ad} functions to apply psychometric corrections to barebones meta-analysis objects via artifact distribution methods.
}
\details{
Allows consolidation of observed and estimated artifact information by cross-correcting artifact distributions and forming weighted artifact summaries.

All artifact distributions are optional; null artifact distributions will be given an artifact value of 1 and a weight of 1 as placeholders.
}
\examples{
create_ad_int(rxxa = c(.9, .8), wt_rxxa = c(50, 150),
              rxxi = c(.8, .7), wt_rxxi = c(50, 150),
              ux = c(.9, .8), wt_ux = c(50, 150),
              ut = c(.8, .7), wt_ut = c(50, 150))
}
\keyword{internal}
