% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_dmod.R
\name{compute_dmod_par}
\alias{compute_dmod_par}
\title{Function for computing parametric \eqn{d_{Mod}}{d_Mod} effect sizes for any number of focal groups}
\usage{
compute_dmod_par(
  referent_int,
  referent_slope,
  focal_int,
  focal_slope,
  focal_mean_x,
  focal_sd_x,
  referent_sd_y,
  focal_min_x,
  focal_max_x,
  focal_names = NULL,
  rescale_cdf = TRUE
)
}
\arguments{
\item{referent_int}{Referent group's intercept.}

\item{referent_slope}{Referent group's slope.}

\item{focal_int}{Focal groups' intercepts.}

\item{focal_slope}{Focal groups' slopes.}

\item{focal_mean_x}{Focal groups' predictor-score means.}

\item{focal_sd_x}{Focal groups' predictor-score standard deviations.}

\item{referent_sd_y}{Referent group's criterion standard deviation.}

\item{focal_min_x}{Focal groups' minimum predictor scores.}

\item{focal_max_x}{Focal groups' maximum predictor scores.}

\item{focal_names}{Focal-group names. If \code{NULL} (the default), the focal groups will be given numeric labels ranging from 1 through the number of groups.}

\item{rescale_cdf}{Logical argument that indicates whether parametric \eqn{d_{Mod}}{d_Mod} results
should be rescaled to account for using a cumulative density < 1 in the computations (\code{TRUE}; default) or not (\code{FALSE}).}
}
\value{
A matrix of effect sizes (\eqn{d_{Mod_{Signed}}}{d_Mod_Signed},
    \eqn{d_{Mod_{Unsigned}}}{d_Mod_Unsigned}, \eqn{d_{Mod_{Under}}}{d_Mod_Under},
    \eqn{d_{Mod_{Over}}}{d_Mod_Over}), proportions of under- and over-predicted criterion scores,
    minimum and maximum differences (i.e., \eqn{d_{Mod_{Under}}}{d_Mod_Under} and \eqn{d_{Mod_{Over}}}{d_Mod_Over}),
    and the scores associated with minimum and maximum differences.
    Note that if the regression lines are parallel and infinite \code{focal_min_x} and \code{focal_max_x} values were
    specified, the extrema will be defined using the scores 3 focal-group SDs above and below the corresponding focal-group means.
}
\description{
This function computes \eqn{d_{Mod}}{d_Mod} effect sizes from user-defined descriptive statistics
and regression coefficients. If one has access to a raw data set, the \code{dMod} function may be used
as a wrapper to this function so that the regression equations and descriptive statistics can
be computed automatically within the program.
}
\details{
The \eqn{d_{Mod_{Signed}}}{d_Mod_Signed} effect size (i.e., the average of differences in prediction over
the range of predictor scores) is computed as
\deqn{d_{Mod_{Signed}}=\frac{1}{SD_{Y_{1}}}\intop f_{2}(X)\left[X\left(b_{1_{1}}-b_{1_{2}}\right)+b_{0_{1}}-b_{0_{2}}\right] dX,}{d_Mod_Signed = 1/SD_Y_1 * integrate(f_2(X) * [X * (b_1_1 - b_1_2) + b_0_1 - b_0_2]),}
where
  \itemize{
    \item {\eqn{SD_{Y_{1}}}{Y_1} is the referent group's criterion standard deviation;}
    \item {\eqn{f_{2}(X)}{f_2(X)} is the normal-density function for the distribution of focal-group predictor scores;}
    \item {\eqn{b_{1_{1}}}{b_1_1} and \eqn{b_{1_{0}}}{b_1_0} are the slopes of the regression of \eqn{Y} on \eqn{X} for the referent and focal groups, respectively;}
    \item {\eqn{b_{0_{1}}}{b_0_1} and \eqn{b_{0_{0}}}{b_0_0} are the intercepts of the regression of \eqn{Y} on \eqn{X} for the referent and focal groups, respectively; and}
    \item {the integral spans all \eqn{X} scores within the operational range of predictor scores for the focal group.}
  }

The \eqn{d_{Mod_{Under}}}{d_Mod_Under} and \eqn{d_{Mod_{Over}}}{d_Mod_Over} effect sizes are computed
using the same equation as \eqn{d_{Mod_{Signed}}}{d_Mod_Signed}, but \eqn{d_{Mod_{Under}}}{d_Mod_Under} is
the weighted average of all scores in the area of underprediction (i.e., the differences in prediction with
negative signs) and \eqn{d_{Mod_{Over}}}{d_Mod_Over} is the weighted average of all scores in the area of
overprediction (i.e., the differences in prediction with negative signs).

The \eqn{d_{Mod_{Unsigned}}}{d_Mod_Unsigned} effect size (i.e., the average of absolute differences in prediction over
the range of predictor scores) is computed as
\deqn{d_{Mod_{Unsigned}}=\frac{1}{SD_{Y_{1}}}\intop f_{2}(X)\left|X\left(b_{1_{1}}-b_{1_{2}}\right)+b_{0_{1}}-b_{0_{2}}\right|dX.}{d_Mod_Unsigned = 1/SD_Y_1 * integrate(f_2(X) * |X * (b_1_1 - b_1_2) + b_0_1 - b_0_2|).}

The \eqn{d_{Min}}{d_Min} effect size (i.e., the smallest absolute difference in prediction observed over the
range of predictor scores) is computed as
\deqn{d_{Min}=\frac{1}{SD_{Y_{1}}}Min\left[\left|X\left(b_{1_{1}}-b_{1_{2}}\right)+b_{0_{1}}-b_{0_{2}}\right|\right].}{d_Min = 1/SD_Y_1 * Min[X * (b_1_1 - b_1_2) + b_0_1 - b_0_2].}

The \eqn{d_{Max}}{d_Max} effect size (i.e., the largest absolute difference in prediction observed over the
range of predictor scores)is computed as
\deqn{d_{Max}=\frac{1}{SD_{Y_{1}}}Max\left[\left|X\left(b_{1_{1}}-b_{1_{2}}\right)+b_{0_{1}}-b_{0_{2}}\right|\right].}{d_Max = 1/SD_Y_1 * Max[X * (b_1_1 - b_1_2) + b_0_1 - b_0_2].}
\emph{Note}: When \eqn{d_{Min}}{d_Min} and \eqn{d_{Max}}{d_Max} are computed in this package, the output will display the
signs of the differences (rather than the absolute values of the differences) to aid in interpretation.

If \eqn{d_{Mod}}{d_Mod} effect sizes are to be rescaled to compensate for a cumulative density less than 1 (see the \code{rescale_cdf} argument), the result of each
effect size involving integration will be divided by the ratio of the cumulative density of the observed range of scores (i.e., the range bounded by the \code{focal_min_x}
and \code{focal_max_x} arguments) to the cumulative density of scores bounded by \code{-Inf} and \code{Inf}.
}
\examples{
compute_dmod_par(referent_int = -.05, referent_slope = .5,
                 focal_int = c(.05, 0, -.05), focal_slope = c(.5, .3, .3),
                 focal_mean_x = c(-.5, 0, -.5), focal_sd_x = rep(1, 3),
                 referent_sd_y = 1,
                 focal_min_x = rep(-Inf, 3), focal_max_x = rep(Inf, 3),
                 focal_names = NULL, rescale_cdf = TRUE)
}
\references{
Nye, C. D., & Sackett, P. R. (2017).
New effect sizes for tests of categorical moderation and differential prediction.
\emph{Organizational Research Methods, 20}(4), 639–664. \doi{10.1177/1094428116644505}
}
