% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetDryAirVolume}
\alias{GetDryAirVolume}
\title{Return dry-air volume given dry-bulb temperature and pressure.}
\usage{
GetDryAirVolume(TDryBulb, Pressure)
}
\arguments{
\item{TDryBulb}{A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]}

\item{Pressure}{A numeric vector of atmospheric pressure in Psi [IP] or Pa [SI]}
}
\value{
A numeric vector of dry air volume in ft3 lb-1 [IP] or in m3 kg-1 [SI]
}
\description{
Return dry-air volume given dry-bulb temperature and pressure.
}
\examples{
SetUnitSystem("IP")
GetDryAirVolume(77:87, 14.696)

SetUnitSystem("SI")
GetDryAirVolume(25:30, 101325)

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1
\itemize{
  \item Eqn 14 for the perfect gas relationship for dry air.
  \item Eqn 1 for the universal gas constant.
  \item The factor 144 in IP is for the conversion of Psi = lb in-2 to lb ft-2.
}
}
