% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetRelHumFromTWetBulb}
\alias{GetRelHumFromTWetBulb}
\title{Return relative humidity given dry-bulb temperature, wet bulb temperature and pressure.}
\usage{
GetRelHumFromTWetBulb(TDryBulb, TWetBulb, Pressure)
}
\arguments{
\item{TDryBulb}{A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]}

\item{TWetBulb}{A numeric vector of wet-bulb temperature in degreeF [IP] or degreeC [SI]}

\item{Pressure}{A numeric vector of atmospheric pressure in Psi [IP] or Pa [SI]}
}
\value{
A numeric vector of relative humidity in range [0, 1]
}
\description{
Return relative humidity given dry-bulb temperature, wet bulb temperature and pressure.
}
\examples{
SetUnitSystem("IP")
GetRelHumFromTWetBulb(80:100, 79.9, 14.696)

SetUnitSystem("SI")
GetRelHumFromTWetBulb(25:40, 20, 101325.0)

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1
}
