% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetDryAirEnthalpy}
\alias{GetDryAirEnthalpy}
\title{Return dry-air enthalpy given dry-bulb temperature.}
\usage{
GetDryAirEnthalpy(TDryBulb)
}
\arguments{
\item{TDryBulb}{A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]}
}
\value{
A numeric vector of dry air enthalpy in Btu lb-1 [IP] or J kg-1 [SI]
}
\description{
Return dry-air enthalpy given dry-bulb temperature.
}
\examples{
SetUnitSystem("IP")
GetDryAirEnthalpy(77:87)

SetUnitSystem("SI")
GetDryAirEnthalpy(10:30)


}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1 eqn 28
}
