% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetHumRatioFromTWetBulb}
\alias{GetHumRatioFromTWetBulb}
\title{Return humidity ratio given dry-bulb temperature, wet-bulb temperature, and pressure.}
\usage{
GetHumRatioFromTWetBulb(TDryBulb, TWetBulb, Pressure)
}
\arguments{
\item{TDryBulb}{A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]}

\item{TWetBulb}{A numeric vector of wet-bulb temperature in degreeF [IP] or degreeC [SI]}

\item{Pressure}{A numeric vector of atmospheric Pressure in Psi [IP] or Pa [SI]}
}
\value{
A numeric vector of humidity ratio in lb_H2O lb_Air-1 [IP] or kg_H2O kg_Air-1 [SI]
}
\description{
Return humidity ratio given dry-bulb temperature, wet-bulb temperature, and pressure.
}
\examples{
SetUnitSystem("IP")
GetHumRatioFromTWetBulb(80:100, 77.0, 14.175)

SetUnitSystem("SI")
GetHumRatioFromTWetBulb(20:30, 19.0, 95461.0)

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1 eqn 33 and 35
}
