% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetRelHumFromTDewPoint}
\alias{GetRelHumFromTDewPoint}
\title{Return relative humidity given dry-bulb temperature and dew-point temperature.}
\usage{
GetRelHumFromTDewPoint(TDryBulb, TDewPoint)
}
\arguments{
\item{TDryBulb}{A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]}

\item{TDewPoint}{A numeric vector of dew-point temperature in degreeF [IP] or degreeC [SI]}
}
\value{
A numeric vector of relative humidity in range [0, 1]
}
\description{
Return relative humidity given dry-bulb temperature and dew-point temperature.
}
\examples{
SetUnitSystem("IP")
GetRelHumFromTDewPoint(80:100, 65)

SetUnitSystem("SI")
GetRelHumFromTDewPoint(20:30, 15)

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1 eqn 22
}
