#' Invert identifier
#'
#' Invert the identifier (generated by [generate_id()] for one or more constructs.
#' This means that the identifier prefix is stripped and the last part is
#' converted back from base 30 to base 10.
#'
#' @param x The identifier(s) as a character vector.
#'
#' @return The identifier(s) as a numeric vector.
#' @export
#'
#' @examples
#' invert_id(generate_id('example'));
invert_id <- function(x) {
  datetimeBit <- gsub("^.*_([^_]+)$",
                      "\\1",
                      x);
  return(base30toNumeric(datetimeBit));
}
