% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Sandler}
\alias{Sandler}
\title{Passive smoking in adulthood and cancer risk.}
\format{A labelled tibble with 998 rows and 3 variables:
\describe{
\item{passive}{Passive smoker, factor with levels "No" and "Yes".}
\item{cancer}{Diagnosed with cancer, factor with levels "No" and "Yes".}
\item{smoke}{Active smoker, factor with levels "No" and "Yes".}
}}
\source{
Sandler, DP, Everson, RB, Wilcox, AJ (1985). Passive smoking in adulthood and cancer risk. Amer J Epidem, 121: 37-48.
}
\usage{
Sandler
}
\description{
A case-control study to investigate the effects of passive smoking
on cancer. Passive smoking was defined as exposure to the cigarette smoke
of a spouse who smoked at least one cigarette per day for at least 6 months.
}
\examples{
data(Sandler)
require(moonBook)

mytable(cancer ~ passive, data = Sandler, show.total = TRUE)

mytable(cancer ~ passive+smoke, data = Sandler, show.total = TRUE)

mhor(cancer ~ smoke/passive, data = Sandler)
}
\keyword{datasets}
