% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_metadata_from_one_pmid.R
\name{get_metadata_from_one_pmid}
\alias{get_metadata_from_one_pmid}
\title{Downloads metadata from Pubmed API for a single provided PMID and
exports}
\usage{
get_metadata_from_one_pmid(pmid, api_key)
}
\arguments{
\item{pmid}{A single PMID, e.g. "29559429"}

\item{api_key}{A valid Pubmed API key}
}
\value{
A named list with 7 elements:

\if{html}{\out{<div class="sourceCode">}}\preformatted{`$pubmed_dl_success`, which is TRUE in the case that a
corresponding Pubmed record was found and metadata
downloaded and FALSE otherwise.

`$doi`, a character string containing the DOI for the
publication with the PMID in question.

`$languages`, a list of languages corresponding to the
publication with the PMID in question.

`$pubtypes`, a list of publication types corresponding to the
publication with the PMID in question.

`$pubdate`, the listed publication date

`$epubdate`, the listed e-publication date

`$authors`, a list of authors of the publication with the PMID
in question.

`$abstract`, a character string containing the abstract for the
publication with the PMID in question.
}\if{html}{\out{</div>}}
}
\description{
Downloads metadata from Pubmed API for a single provided PMID and
exports
}
\examples{

\dontrun{
## Read in API key
ak <- readLines("api_key.txt")

## Download Pubmed metadata
mdata <- get_metadata_from_one_pmid("29559429", ak)

## Extract first author
mdata$authors[1]
}
}
