% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_metadata_from_pmids.R
\name{get_metadata_from_pmids}
\alias{get_metadata_from_pmids}
\title{Downloads metadata from Pubmed API for a column of PMID's in a data
frame}
\usage{
get_metadata_from_pmids(df, column, api_key, quiet = FALSE)
}
\arguments{
\item{df}{A dataframe containing a column of PMID's}

\item{column}{The name of the column containing PMID's}

\item{api_key}{A valid Pubmed API key}

\item{quiet}{A boolean TRUE or FALSE. If TRUE, no progress messages
will be printed during download. FALSE by default, messages
printed for every version downloaded showing progress.}
}
\value{
A data frame containing the original columns as well as
seven additional columns:

\if{html}{\out{<div class="sourceCode">}}\preformatted{The `pubmed_dl_success` column is TRUE in the case that
metadata were successfully downloaded from Pubmed; FALSE in the
case that an error occurred during downloading (e.g. due to a
number that is well-formed but does not correspond to a true
PMID); NA in the case that the supplied PMID is not well-formed
(e.g. NA or non-numeric).

The `doi` column returns a DOI that corresponds to the PMID
supplied if one is found, NA otherwise.

The `languages` column contains a JSON-encoded list of
languages for the article in question.

The `pubtypes` column contains a JSON-encoded list of
publication types for the article in question.

The `pubdate` column contains a character string with the
publication date

The `epubdate` column contains a character string with the
e-publication date

The `authors` column contains a JSON-encoded list of authors
for the article in question.

The `abstract` column contains a character string with the
abstract for the article in question.
}\if{html}{\out{</div>}}
}
\description{
Downloads metadata from Pubmed API for a column of PMID's in a data
frame
}
\examples{

\dontrun{
## Read in API key
ak <- readLines("api_key.txt")

## Example publications and their corresponding PMID's (some valid
## and some not)
pubs <- tibble::tribble(
  ~pmid,
  "29559429",
  "28837722",
  NA,
  "borp",
  "98472657638729"
)

## Download Pubmed metadata
pm_meta <- get_metadata_from_pmids(pubs, "pmid", ak)

## Extract DOI's for those that were successfully downloaded
pm_meta \%>\%
  dplyr::filter(pubmed_dl_success)
  dplyr::select(pmid, doi)

## A tibble: 2 × 2
##   pmid     doi                    
##   <chr>    <chr>                  
## 1 29559429 10.1136/bmj.k959       
## 2 28837722 10.1001/jama.2017.11502

}
}
