% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snapshot_naive.R
\name{snapshot_naive}
\alias{snapshot_naive}
\title{snapshot_naive}
\usage{
snapshot_naive(ri, ni, m1i, m2i, n1i, n2i, sd1i, sd2i, tobs)
}
\arguments{
\item{ri}{A vector of length two containing the raw correlation coefficients
of the original study and replication}

\item{ni}{A vector of length two containing the sample size of the original 
study and replication for the raw correlation coefficient}

\item{m1i}{A vector of length two containing the means in group 1 for the original
study and replication for two-independent means}

\item{m2i}{A vector of length two containing the means in group 2 for the original
and replication for two-independent means}

\item{n1i}{A vector of length two containing the sample sizes in group 1 for
the original study and replication for two-independent means}

\item{n2i}{A vector of length two containing the sample sizes in group 2 for
the original study and replication for two-independent means}

\item{sd1i}{A vector of length two containing the standard deviations in group 1
for the original study and replication for two-independent means}

\item{sd2i}{A vector of length two containing the standard deviations in group 2
for the original study and replication for two-independent means}

\item{tobs}{A vector of length two containing the t-values of the original
study and replication}
}
\value{
The \code{snapshot.naive} function returns a data frame with posterior
probabilities for no (\code{p.0}), small (\code{p.sm}), medium (\code{p.me}),
and large (\code{p.la}) true effect size.
}
\description{
Function for applying Snapshot Bayesian Meta-Analysis Method (snapshot naive)
for two-independent means and raw correlation coefficients.
}
\details{
The function computes posterior probabilities (assuming a uniform prior
distribution) for four true effect sizes (no, small, medium, and large) based
on an original study and replication. For more information see van Aert and
van Assen (2016).

Two different effect size measures can be used as input for the \code{snapshot.naive}
function: two-independent means and raw correlation coefficients.
Analyzing two-independent means can be done by either providing
the function group means (\code{m1i} and \code{m2i}), standard deviations
(\code{sd1i} and \code{sd2i}), and sample sizes (\code{n1i} and \code{n2i}) or
t-values (\code{tobs}) and sample sizes (\code{n1i} and \code{n2i}).See the Example section for
an example. Raw correlation coefficients can be analyzed by supplying \code{ri}
and \code{ni} to the \code{snapshot.naive}.
}
\examples{
### Example as presented on page 491 in Maxwell, Lau, and Howard (2015)
snapshot_naive(ri = c(0.243, 0.114), ni = c(80, 172))

}
\references{
van Aert, R.C.M. & van Assen, M.A.L.M. (2017). Bayesian evaluation
of effect size after replicating an original study. PLoS ONE, 12(4), e0175302. 
doi:10.1371/journal.pone.0175302
}
\author{
Robbie C.M. van Aert \email{R.C.M.vanAert@tilburguniversity.edu}
}
