% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check_reference}
\alias{check_reference}
\alias{check_target}
\title{Check columns with reference individuals}
\usage{
check_reference(ped, reference, variable)

check_target(ped, reference, target, variable)
}
\arguments{
\item{ped}{A dataframe containing the pedigree. Individual (id), maternal (dam), and paternal (sire) identities are mandatory columns.}

\item{reference}{A string naming a column indicating whether individuals belong to the reference population or not. Column must be boolean or coercible to boolean type.}

\item{variable}{To be used in printed messages}

\item{target}{Target column}
}
\value{
Vector of reference numbers (if checks are successful)

Vector of target numbers (if checks are successful)
}
\description{
Takes a column name, and checks its use as reference.
It should name a boolean vector (or coercible to it),
with at least one TRUE value.

Takes a column name, and checks its use as target.
It should name a boolean vector (or coercible to it),
with at least one TRUE value.
}
