% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maternal.R
\name{ped_maternal}
\alias{ped_maternal}
\title{Maternal effects}
\usage{
ped_maternal(ped, value_from, name_to, use_dam = TRUE, set_na = NULL)
}
\arguments{
\item{ped}{A dataframe containing the pedigree. Individual (id), maternal (dam), and paternal (sire) identities are mandatory columns.}

\item{value_from}{Name of the column of interest.}

\item{name_to}{A string naming the new output column.}

\item{use_dam}{Extract maternal values. If false, parental values are returned.}

\item{set_na}{When maternal values are unknown, NA values are generated by default. This option allows to set a different value.}
}
\value{
The input dataframe, plus an additional column with maternal (or paternal) values of a variable of interest.
}
\description{
For every individual in the pedigree, it will assign them their maternal (or
paternal) value for an observed variable of interest.
}
\examples{
# To assign maternal inbreeding as a new variable, we can do as follows:
data(dama)
dama <- ip_F(dama)
dama <- ped_maternal(dama, value_from = "Fi", name_to = "Fdam")
tail(dama)
}
