% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pushover_api.R
\name{pushover_api}
\alias{pushover_api}
\title{Issue a command using the Pushover API}
\usage{
pushover_api(verb, url, visible = TRUE, ...)
}
\arguments{
\item{verb}{The http method to use}

\item{url}{The URL to visit}

\item{visible}{Whether or not the result should be visible (default: \code{TRUE})}

\item{...}{Any additional parameters to be passed to \code{\link[httr]{VERB}}}
}
\value{
a list containing the following fields and any other fields related
to the specific API call:
\itemize{
    \item \code{status}: request status (1 = success)
    \item \code{request}: unique request ID
    \item \code{raw}: the raw \code{\link[httr]{response}} object
    \item \code{errors}: a list of error messages (only for unsuccessful requests)
}
}
\description{
\code{pushover_api} allows commands to be issued using the Pushover API.
This is a generic function that is meant to be used by higher level
functions. In most instances, more specific functions should be used (e.g.,
\code{\link{pushover}}).
}
\examples{
\dontrun{
pushover_api(verb = "GET",
             url = "https://api.pushover.net/1/sounds.json",
             query = list(token = "azGDORePK8gMaC0QOYAMyEEuzJnyUi"))
}
}

