\name{Rating.getCandidateRating}
\alias{Rating.getCandidateRating}
\title{Get a candidate's rating by special interest groups}
\usage{
Rating.getCandidateRating(candidateId, sigId=NULL)
}
\arguments{
  \item{candidateId}{a character string or list of
  character strings with the candidateId(s) (see references
  for details)}

  \item{sigId}{(optional) a character string or list of
  character strings with the special interest group's ID(s)
  (see references for details)}
}
\value{
A data frame with a row for each rating of a candidate and
columns with the following variables describing the
candidate:\cr candidateRating.candidate.title,\cr
candidateRating.candidate.firstName,\cr
candidateRating.candidate.middleName,\cr
candidateRating.candidate.lastName,\cr
candidateRating.candidate.suffix,\cr
candidateRating.candidate.office,\cr
candidateRating.rating*.sigId,\cr
candidateRating.rating*.ratingId,\cr
candidateRating.rating*.categories.category*.categoryId,\cr
candidateRating.rating*.categories.category*.name,\cr
candidateRating.rating*.timeSpan,\cr
candidateRating.rating*.rating,\cr
candidateRating.rating*.ratingName,\cr
candidateRating.rating*.ratingText.
}
\description{
This function is a wrapper for the
Rating.getCandidateRating() method of the PVS API Rating
class which grabs a candidate's rating by special interest
groups (SIG). The function sends a request with this method
to the PVS API for all candidate and SIG IDs given as a
function input, extracts the XML values from the returned
XML file(s) and returns them arranged in one data frame.
}
\examples{
# First, make sure your personal PVS API key is saved as character string in the pvs.key variable:
\dontrun{pvs.key <- "yourkey"}
# get ratings by candidate and special interest group
\dontrun{rating <- Rating.getCandidateRating(candidateId="9490")}
\dontrun{head(rating)}
}
\author{
Ulrich Matter <ulrich.matter-at-unibas.ch>
}
\references{
http://api.votesmart.org/docs/Rating.html\cr Use
Candidates.getByOfficeState(),
Candidates.getByOfficeTypeState(),
Candidates.getByLastname(), Candidates.getByLevenshtein(),
Candidates.getByElection(), Candidates.getByDistrict() or
Candidates.getByZip() to get a list of candidate IDs.\cr
Use Rating.getSigList() to get a list of special interest
group's IDs.
}

