% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anc.R
\name{anc}
\alias{anc}
\title{Compute Power for One or Two Factor ANCOVA with a single covariate
Takes means, sds, and sample sizes for each group. Alpha is .05 by default, alternative values may be entered by user}
\usage{
anc(m1.1, m2.1, m1.2, m2.2, m1.3 = NULL, m2.3 = NULL, m1.4 = NULL,
  m2.4 = NULL, s1.1 = NULL, s2.1 = NULL, s1.2 = NULL,
  s2.2 = NULL, s1.3 = NULL, s2.3 = NULL, s1.4 = NULL,
  s2.4 = NULL, r, s = NULL, alpha = 0.05, factors, n)
}
\arguments{
\item{m1.1}{Cell mean for First level of Factor A, First level of Factor B}

\item{m2.1}{Cell mean for Second level of Factor A, First level of Factor B}

\item{m1.2}{Cell mean for First level of Factor A, Second level of Factor B}

\item{m2.2}{Cell mean for Second level of Factor A, Second level of Factor B}

\item{m1.3}{Cell mean for First level of Factor A, Third level of Factor B}

\item{m2.3}{Cell mean for Second level of Factor A, Third level of Factor B}

\item{m1.4}{Cell mean for First level of Factor A, Fourth level of Factor B}

\item{m2.4}{Cell mean for Second level of Factor A, Fourth level of Factor B}

\item{s1.1}{Cell standard deviation for First level of Factor A, First level of Factor B}

\item{s2.1}{Cell standard deviation for Second level of Factor A, First level of Factor B}

\item{s1.2}{Cell standard deviation for First level of Factor A, Second level of Factor B}

\item{s2.2}{Cell standard deviation for Second level of Factor A, Second level of Factor B}

\item{s1.3}{Cell standard deviation for First level of Factor A, Third level of Factor B}

\item{s2.3}{Cell standard deviation for Second level of Factor A, Third level of Factor B}

\item{s1.4}{Cell standard deviation for First level of Factor A, Fourth level of Factor B}

\item{s2.4}{Cell standard deviation for Second level of Factor A, Fourth level of Factor B}

\item{r}{Correlation between covariate and dependent variable.}

\item{s}{Overall standard deviation. Sets all cell sds equal}

\item{alpha}{Type I error (default is .05)}

\item{factors}{Number of factors (1 or 2)}

\item{n}{Sample Size per cell}
}
\value{
Power for One or Two Factor ANCOVA with a single covariate
}
\description{
Compute Power for One or Two Factor ANCOVA with a single covariate
Takes means, sds, and sample sizes for each group. Alpha is .05 by default, alternative values may be entered by user
}
\examples{
anc(m1.1=.85,m2.1=2.5, s1.1 = 1.7, s2.1=1,
m1.2=0.85, m2.2= 2.5, s1.2 = 1.7, s2.2=1,
m1.3=0.0,m2.3=2.5, s1.3 = 1.7, s2.3=1,
m1.4=0.6, m2.4 = 2.5, s1.4 = 1.7, s2.4=1, r= 0.4,
n=251, factors =2)
}
