% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MANOVA1f.R
\name{MANOVA1f}
\alias{MANOVA1f}
\title{Compute power for a One Factor MANOVA with up to two levels and up to four measures.
Takes means, sds, and sample sizes for each group. Alpha is .05 by default, alternative values may be entered by user}
\usage{
MANOVA1f(
  m1.1,
  m2.1,
  m3.1 = NA,
  m4.1 = NA,
  m1.2,
  m2.2,
  m3.2 = NA,
  m4.2 = NA,
  s1.1 = NA,
  s2.1 = NA,
  s3.1 = NA,
  s4.1 = NA,
  s1.2 = NA,
  s2.2 = NA,
  s3.2 = NA,
  s4.2 = NA,
  r1.2_1 = NULL,
  r1.3_1 = NULL,
  r1.4_1 = NULL,
  r2.3_1 = NULL,
  r2.4_1 = NULL,
  r3.4_1 = NULL,
  r1.2_2 = NULL,
  r1.3_2 = NULL,
  r1.4_2 = NULL,
  r2.3_2 = NULL,
  r2.4_2 = NULL,
  r3.4_2 = NULL,
  r = NULL,
  s = NULL,
  n,
  alpha = 0.05
)
}
\arguments{
\item{m1.1}{Mean of first DV, 1st level Between Factor}

\item{m2.1}{Mean of second DV, 1st level Between Factor}

\item{m3.1}{Mean of third DV, 1st level Between Factor}

\item{m4.1}{Mean of fourth DV, 1st level Between Factor}

\item{m1.2}{Mean of first DV, 2nd level Between Factor}

\item{m2.2}{Mean of second DV, 2nd level Between Factor}

\item{m3.2}{Mean of third DV, 2nd level Between Factor}

\item{m4.2}{Mean of fourth DV, 2nd level Between Factor}

\item{s1.1}{Standard deviation of first DV, 1st level Between Factor}

\item{s2.1}{Standard deviation of second DV, 1st level Between Factor}

\item{s3.1}{Standard deviation of third DV, 1st level Between Factor}

\item{s4.1}{Standard deviation of forth DV, 1st level Between Factor}

\item{s1.2}{Standard deviation of first DV, 2nd level Between Factor}

\item{s2.2}{Standard deviation of second DV, 2nd level Between Factor}

\item{s3.2}{Standard deviation of third DV, 2nd level Between Factor}

\item{s4.2}{Standard deviation of forth DV, 2nd level Between Factor}

\item{r1.2_1}{correlation DV 1 and DV 2, 1st level Between}

\item{r1.3_1}{correlation DV 1 and DV 3, 1st level Between}

\item{r1.4_1}{correlation DV 1 and DV 4, 1st level Between}

\item{r2.3_1}{correlation DV 1 and DV 3, 1st level Between}

\item{r2.4_1}{correlation DV 1 and DV 4, 1st level Between}

\item{r3.4_1}{correlation DV 1 and DV 4, 1st level Between}

\item{r1.2_2}{correlation DV 1 and DV 2, 2nd level Between}

\item{r1.3_2}{correlation DV 1 and DV 3, 2nd level Between}

\item{r1.4_2}{correlation DV 1 and DV 4, 2nd level Between}

\item{r2.3_2}{correlation DV 1 and DV 3, 2nd level Between}

\item{r2.4_2}{correlation DV 1 and DV 4, 2nd level Between}

\item{r3.4_2}{correlation DV 1 and DV 4, 2nd level Between}

\item{r}{sets same correlations between DVs on all factor levels (seriously, just use this)}

\item{s}{sets same standard deviation for factor levels (see comment above)}

\item{n}{Sample size for first group}

\item{alpha}{Type I error (default is .05)}
}
\value{
Power for the One Factor Within Subjects and One Factor Between ANOVA
}
\description{
Compute power for a One Factor MANOVA with up to two levels and up to four measures.
Takes means, sds, and sample sizes for each group. Alpha is .05 by default, alternative values may be entered by user
}
\examples{
MANOVA1f(n=40,m1.1=0,m2.1=1,m3.1=2.4,m4.1=-0.7,
m1.2=-0.25,m2.2=-2,m3.2=2,m4.2=-1,
s1.1=.4,s2.1=5,s3.1=1.6,s4.1=1.2,
s1.2=.4,s2.2=5,s3.2=1.6,s4.2=1.2,
r1.2_1=.1,r1.3_1=.1,r1.4_1=.1,
r2.3_1=.35,r2.4_1=.45,r3.4_1=.40,
r1.2_2=.1,r1.3_2=.1,r1.4_2=.1,
r2.3_2=.35,r2.4_2=.45,r3.4_2=.40,alpha=.05)
MANOVA1f(n=40,m1.1=0,m2.1=1,m3.1=2.4,m4.1=-0.7,
m1.2=-0.25,m2.2=-2,m3.2=2,m4.2=-1,
s=.4,r=.5,alpha=.05)
}
