% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modmed14.R
\name{modmed14}
\alias{modmed14}
\title{Compute Power for Conditional Process Model 14 Joint Significance
Requires correlations between all variables as sample size.
This is the recommended approach for determining power}
\usage{
modmed14(
  rxw,
  rxm,
  rxxw,
  rxy,
  rwm = 0,
  rxww,
  rwy,
  rxwm = 0,
  rxwy,
  rmy,
  n,
  alpha = 0.05,
  rep = 5000
)
}
\arguments{
\item{rxw}{Correlation between predictor (x) and moderator (w)}

\item{rxm}{Correlation between predictor (x) and mediator (m)}

\item{rxxw}{Correlation between predictor (x) and xweraction term (xw) - defaults to 0}

\item{rxy}{Correlation between DV (y) and predictor (x)}

\item{rwm}{Correlation between moderator (w) and mediator (m)}

\item{rxww}{Correlation between moderator (w) and xweraction (xw) - defaults to 0}

\item{rwy}{Correlation between DV (y) and moderator (w)}

\item{rxwm}{Correlation between mediator (m) and xweraction (xw) - Key value}

\item{rxwy}{Correlation between DV (y) and xweraction (xw) - defaults to 0}

\item{rmy}{Correlation between DV (y) and mediator (m)}

\item{n}{Sample size}

\item{alpha}{Type I error (default is .05)}

\item{rep}{Number of samples drawn (defaults to 5000)}
}
\value{
Power for Model 14 Conditional Processes
}
\description{
Compute Power for Conditional Process Model 14 Joint Significance
Requires correlations between all variables as sample size.
This is the recommended approach for determining power
}
\examples{
\donttest{modmed14(rxw<-.2, rxm<-.3, rxxw=0, rxy=.31,rwm=.4,
rxww=0.5,rwy<-.35, rxwm<-.41, rxwy=.51,
rmy=.32, n=200, rep=1000,alpha=.05)}
}
