/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1;

import eu.kliegr.ac1.BaseConfig;
import eu.kliegr.ac1.data.AttributeType;
import eu.kliegr.ac1.rule.CBARuleComparator;
import eu.kliegr.ac1.rule.extend.DefaultRuleOverlapPruningType;
import eu.kliegr.ac1.rule.extend.ExtendRuleConfig;
import eu.kliegr.ac1.rule.extend.ExtendType;
import eu.kliegr.ac1.rule.extend.ExtensionStrategyEnum;
import eu.kliegr.ac1.rule.extend.PostPruningType;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Properties;
import java.util.logging.Logger;

public class ExtendConfig
extends BaseConfig {
    private static final Logger LOGGER = Logger.getLogger(ExtendConfig.class.getName());
    private String rulesPath = "/home/tomas/NetBeansProjects/AC1/resources/Iris1_iris_1_0.5.xml";
    private String extendRuleSortComparator = "CBARuleComparator";
    private boolean annotate = false;
    private PostPruningType postpruningType = PostPruningType.none;
    private boolean continuosPruning = false;
    private boolean performFuzzification = false;
    private boolean isTrimmingEnabled = false;
    private boolean isAttributePruningEnabled = false;
    private DefaultRuleOverlapPruningType defaultRuleOverlapPruning = DefaultRuleOverlapPruningType.noPruning;
    private Comparator ruleComparator;
    private ExtendType extendType;
    private ExtendRuleConfig extConf;

    public ExtendConfig() {
    }

    public ExtendConfig(ArrayList<AttributeType> attType, String targetAttribute, String IDcolumnName) {
        this.ruleComparator = new CBARuleComparator();
        this.extendType = ExtendType.numericOnly;
        this.annotate = false;
        this.postpruningType = PostPruningType.cba;
        this.continuosPruning = false;
        this.isTrimmingEnabled = true;
        this.performFuzzification = false;
        this.attType = attType;
        this.targetAttribute = targetAttribute;
        this.IDcolumnName = IDcolumnName;
    }

    public ExtendConfig(String path) throws FileNotFoundException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String _fuzz;
        String _trim;
        String _prune_cont;
        String _redundant;
        String _prune;
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(path));
        Properties prop = new Properties();
        prop.loadFromXML(input);
        this.rulesPath = prop.getProperty("RulesPath");
        this.dataPath = prop.getProperty("TrainDataPath");
        String _extendRuleSortComparator = prop.getProperty("ExtendRuleSortComparator");
        if (_extendRuleSortComparator != null) {
            this.extendRuleSortComparator = _extendRuleSortComparator;
        }
        this.ruleComparator = (Comparator)Class.forName("eu.kliegr.ac1.rule." + this.extendRuleSortComparator).newInstance();
        this.extendType = ExtendType.valueOf(prop.getProperty("ExtendType"));
        String _ann = prop.getProperty("Annotate");
        if (_ann != null) {
            this.annotate = Boolean.valueOf(_ann);
        }
        if ((_prune = prop.getProperty("Postpruning")) != null) {
            this.postpruningType = PostPruningType.valueOf(_prune);
        }
        String _attprune = prop.getProperty("AttributePruning");
        if (_prune != null) {
            this.isAttributePruningEnabled = Boolean.valueOf(_attprune);
        }
        if ((_redundant = prop.getProperty("DefaultRuleOverlapPruning")) != null) {
            this.defaultRuleOverlapPruning = DefaultRuleOverlapPruningType.valueOf(_redundant);
        }
        if ((_prune_cont = prop.getProperty("ContinuousPruning")) != null) {
            this.continuosPruning = Boolean.valueOf(_prune_cont);
        }
        if ((_trim = prop.getProperty("Trimming")) != null) {
            this.isTrimmingEnabled = Boolean.valueOf(_trim);
        }
        if ((_fuzz = prop.getProperty("Fuzzification")) != null) {
            this.performFuzzification = Boolean.valueOf(_prune_cont);
        }
        this.setOutputPath(prop.getProperty("OutputPath"));
        this.csvSeparator = prop.getProperty("DataTypes").contains(";") ? ";" : ",";
        String _mci = prop.getProperty("MinCondImprovement");
        String _mi = prop.getProperty("MinImprovement");
        String _mc = prop.getProperty("MinConfidence");
        String _mt = prop.getProperty("ExtensionTypeEnum");
        this.extConf = _mci != null && _mi != null && _mc != null && _mt != null ? new ExtendRuleConfig(Double.valueOf(_mi), Double.valueOf(_mci), Double.valueOf(_mc), ExtensionStrategyEnum.valueOf(_mt)) : new ExtendRuleConfig();
        this.attType = this.parseAttributeTypes(prop.getProperty("DataTypes").split(this.csvSeparator));
        this.targetAttribute = prop.getProperty("TargetAttribute");
        this.IDcolumnName = prop.getProperty("IDcolumnName");
    }

    public Comparator getRuleComparator() {
        return this.ruleComparator;
    }

    public ExtendRuleConfig getExtendRuleConfig() {
        return this.extConf;
    }

    public Boolean isAnnotationEnabled() {
        return this.annotate;
    }

    public Boolean isContinuousPruningEnabled() {
        return this.continuosPruning;
    }

    public Boolean isExtendEnabled() {
        if (this.extendType == ExtendType.noExtend) {
            return false;
        }
        return true;
    }

    public DefaultRuleOverlapPruningType getDefaultRuleOverlapPruningType() {
        return this.defaultRuleOverlapPruning;
    }

    public Boolean isTrimmingEnabled() {
        return this.isTrimmingEnabled;
    }

    public PostPruningType getPostPruningType() {
        return this.postpruningType;
    }

    public Boolean isAttributePruningEnabled() {
        return this.isAttributePruningEnabled;
    }

    public Boolean isFuzzificationEnabled() {
        return this.performFuzzification;
    }

    public String getRulesPath() {
        return this.rulesPath;
    }

    public String getOutputSeedRulesPath() {
        return this.getOutputPath("seed");
    }

    public String getOutputExtendedRulesPath() {
        return this.getOutputPath("arules");
    }

    public String getOutputSummaryPath() {
        return this.getOutputPath("summary");
    }

    public ExtendType getExtendType() {
        return this.extendType;
    }
}

