% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qb_usertoken.R
\name{clone_token}
\alias{clone_token}
\title{Clone a user token}
\usage{
clone_token(
  subdomain,
  auth,
  agent = NULL,
  clone_name = NULL,
  clone_desc = NULL
)
}
\arguments{
\item{subdomain}{Character vector with one element. Found at the beginning of
the Quickbase URL. Realm specific.}

\item{auth}{Character vector with one element. The Quickbase authentication
scheme you are using to authenticate the request (e.g., user token).}

\item{agent}{Optional. Character vector with one element. Describes
user/agent making API call.}

\item{clone_name}{Optional. Character vector with one element. Name the token
clone.}

\item{clone_desc}{Optional. Character vector with one element. Provide a
description for the token clone.}
}
\value{
A character vector with one element containing the token clone.
}
\description{
\code{clone_token} makes a copy of the supplied token and returns its value.
}
\examples{
\dontrun{
   x <- clone_token(subdomain = "abc",
                    auth = keyring::key_get("qb_example"),
                    clone_name = "My new token",
                    clone_desc = "This clone was created using R")
}
}
\references{
\href{https://developer.quickbase.com}{Quickbase API
documentation}
}
