% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qb_reports.R
\name{get_reports}
\alias{get_reports}
\title{Get reports for a table}
\usage{
get_reports(subdomain, auth, table_id, agent = NULL)
}
\arguments{
\item{subdomain}{Character vector with one element. Found at the beginning of
the Quickbase URL. Realm specific.}

\item{auth}{Character vector with one element. The Quickbase authentication
scheme you are using to authenticate the request (e.g., user token).}

\item{table_id}{Character vector with one element. Found in the URL of a
Quickbase table between /db/ and ?}

\item{agent}{Optional. Character vector with one element. Describes
user/agent making API call.}
}
\value{
A tibble.
}
\description{
\code{get_reports} retrieves metadata for each report in a table.
}
\examples{
\dontrun{
   get_reports(subdomain = "abc",
              auth = keyring::key_get("qb_example"),
              table_id = "bn9d8iesz")
}
}
