% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qb_users.R
\name{get_users}
\alias{get_users}
\title{Get users}
\usage{
get_users(
  subdomain,
  auth,
  agent = NULL,
  account_id = NULL,
  user_emails = NULL,
  app_ids = NULL
)
}
\arguments{
\item{subdomain}{Character vector with one element. Found at the beginning of
the Quickbase URL. Realm specific.}

\item{auth}{Character vector with one element. The Quickbase authentication
scheme you are using to authenticate the request (e.g., user token).}

\item{agent}{Optional. Character vector with one element. Describes
user/agent making API call.}

\item{account_id}{Optional. Positive integer. The account ID being used to
get users. If no value is specified, the first account associated with the
requesting user token is chosen.}

\item{user_emails}{Optional. List of characters. Limit returned users to those
specified in this list.}

\item{app_ids}{Optional. List of characters. Limit returned users to those
assigned to these app ID's. The provided app ID's should belong to the same
account.}
}
\value{
A tibble.
}
\description{
Get all users in an account. Provides options to limit
values to a set of users and/or apps.
}
\examples{
\dontrun{
   get_users(subdomain = "abc",
             auth = keyring::key_get("qb_example"))
}
}
