% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_contraction.R
\name{replace_contraction}
\alias{replace_contraction}
\title{Replace Contractions}
\usage{
replace_contraction(text.var, contraction = qdapDictionaries::contractions,
  replace = NULL, ignore.case = TRUE, sent.cap = TRUE)
}
\arguments{
\item{text.var}{The text variable.}

\item{contraction}{A two column key of contractions (column 1) and expanded 
form replacements (column 2) or a vector of contractions.  Default is to use 
qdapDictionaries's \code{\link[qdapDictionaries]{contractions}} data set.}

\item{replace}{A vector of expanded form replacements if a data frame is not 
supplied to the contraction argument.}

\item{ignore.case}{logical.  If \code{TRUE} replaces without regard to 
capitalization.}

\item{sent.cap}{logical.  If \code{TRUE} capitalizes the beginning of every 
sentence.}
}
\value{
Returns a vector with contractions replaced.
}
\description{
This function replaces contractions with long form.
}
\examples{
\dontrun{
x <- c("Mr. Jones isn't going.",  
    "Check it out what's going on.",
    "He's here but didn't go.",
    "the robot at t.s. wasn't nice", 
    "he'd like it if i'd go away")

replace_contraction(x)
}
}
\seealso{
\code{\link[qdap]{bracketX}},
\code{\link[qdap]{qprep}},
\code{\link[qdap]{replace_abbreviation}},
\code{\link[qdap]{replace_number}},
\code{\link[qdap]{replace_symbol}}
}
\keyword{contraction}
