% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pad.R
\name{pad}
\alias{pad}
\title{Pad Strings}
\usage{
pad(x, padding = max(nchar(as.character(x))), sort = TRUE,
  type = "detect")
}
\arguments{
\item{x}{A character, factor, numeric vector.}

\item{padding}{Number of characters to pad.  Default makes all elements of a
string the number of characters of the element with the maximum characters.}

\item{sort}{logical.  If \code{TRUE} the outcome is sorted.}

\item{type}{A character string of \code{"detect"}, \code{"numeric"},
\code{"character"}, \code{"d"} or \code{"s"}.  If numeric zeros are padded.
If character spaces are padded.  The \code{detect} attempts to determine if x
is numeric (d) or not (s).}
}
\value{
Returns a character vector every element padded with 0/spaces.
}
\description{
A convenience wrapper for \code{\link[base]{sprintf}} that pads the front end
of strings with spaces or 0s. Useful for creating multiple uniform directories
that will maintain correct order.
}
\note{
\code{pad} is a wrapper for the \code{\link[base]{sprintf}} function.
\code{pad} may behave differently on various platforms in accordance with the
documentation for \code{\link[base]{sprintf}}: "actual implementation will
follow the C99 standard and fine details (especially the behaviour under user
error) may depend on the platform."  See \code{\link[base]{sprintf}} for more
information.
}
\examples{
pad(sample(1:10, 10))
pad(sample(1:10, 10), sort=FALSE)
pad(as.character(sample(1:10, 10)))
pad(as.character(sample(1:10, 10)), sort=FALSE)
pad(as.character(sample(1:10, 10)), 4)
pad(month.name)
}
\seealso{
\code{\link[base]{sprintf}}
}

