% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id.R
\name{id}
\alias{id}
\title{ID By Row Number or Sequence Along}
\usage{
id(x, prefix = FALSE, pad = TRUE, ...)
}
\arguments{
\item{x}{A dataframe, matrix, vector, or list object.}

\item{prefix}{A character string to use as a prefix. \code{FALSE} or 
\code{NULL} results in no prefix being used.  \code{TRUE} will utilize the 
prefix \code{"X."}.}

\item{pad}{logical.  If \code{TRUE} the beginning number will be padded with 
zeros.}

\item{\ldots}{Other arguments passed to \code{\link[qdapTools]{pad}}.}
}
\value{
Returns a vector of sequential integers.
}
\description{
Generate a sequence of integers the 
\code{\link[base]{length}}/\code{\link[base]{ncol}} of an object.
}
\examples{
id(list(1, 4, 6))
id(matrix(1:10, ncol=1))
id(mtcars)
id(mtcars, TRUE)
id("w")
id(mtcars, prefix="id-")
\dontrun{
library(qdap)
question_type(DATA.SPLIT$state, id(DATA.SPLIT, TRUE))
}
}
\keyword{id}
